/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.relational.tvf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.relational.table.MapTableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.DescribedSchema;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.TableParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.ColumnBuilder;

public class CapacityTableFunction
implements TableFunction {
    private static final String DATA_PARAMETER_NAME = "DATA";
    private static final String SIZE_PARAMETER_NAME = "SIZE";

    public List<ParameterSpecification> getArgumentsSpecifications() {
        return Arrays.asList(TableParameterSpecification.builder().name(DATA_PARAMETER_NAME).passThroughColumns().build(), ScalarParameterSpecification.builder().name(SIZE_PARAMETER_NAME).type(Type.INT64).build());
    }

    public TableFunctionAnalysis analyze(Map<String, Argument> arguments) throws UDFException {
        long size = (Long)((ScalarArgument)arguments.get(SIZE_PARAMETER_NAME)).getValue();
        if (size <= 0L) {
            throw new UDFException("Size must be greater than 0");
        }
        MapTableFunctionHandle handle = new MapTableFunctionHandle.Builder().addProperty(SIZE_PARAMETER_NAME, (Object)size).build();
        return TableFunctionAnalysis.builder().properColumnSchema(new DescribedSchema.Builder().addField("window_index", Type.INT64).build()).requireRecordSnapshot(false).requiredColumns(DATA_PARAMETER_NAME, Collections.singletonList(0)).handle((TableFunctionHandle)handle).build();
    }

    public TableFunctionHandle createTableFunctionHandle() {
        return new MapTableFunctionHandle();
    }

    public TableFunctionProcessorProvider getProcessorProvider(TableFunctionHandle tableFunctionHandle) {
        final long sz = (Long)((MapTableFunctionHandle)tableFunctionHandle).getProperty(SIZE_PARAMETER_NAME);
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor() {
                return new CapacityDataProcessor(sz);
            }
        };
    }

    private static class CapacityDataProcessor
    implements TableFunctionDataProcessor {
        private final long size;
        private long currentStartIndex = 0L;
        private long curIndex = 0L;
        private long windowIndex = 0L;

        public CapacityDataProcessor(long size) {
            this.size = size;
        }

        public void process(Record input, List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            if (this.curIndex - this.currentStartIndex == this.size) {
                this.outputWindow(properColumnBuilders, passThroughIndexBuilder);
                this.currentStartIndex = this.curIndex;
            }
            ++this.curIndex;
        }

        public void finish(List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            this.outputWindow(properColumnBuilders, passThroughIndexBuilder);
        }

        private void outputWindow(List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            for (long i = this.currentStartIndex; i < this.curIndex; ++i) {
                properColumnBuilders.get(0).writeLong(this.windowIndex);
                passThroughIndexBuilder.writeLong(i);
            }
            ++this.windowIndex;
        }
    }
}

