/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import org.apache.ratis.util.TimeDuration;

@FunctionalInterface
public interface RetryPolicy {
    public static final Action NO_RETRY_ACTION = new Action(){

        @Override
        public boolean shouldRetry() {
            return false;
        }

        @Override
        public TimeDuration getSleepTime() {
            return TimeDuration.ZERO;
        }
    };
    public static final Action RETRY_WITHOUT_SLEEP_ACTION = () -> TimeDuration.ZERO;

    public Action handleAttemptFailure(Event var1);

    @FunctionalInterface
    public static interface Action {
        default public boolean shouldRetry() {
            return true;
        }

        public TimeDuration getSleepTime();
    }

    @FunctionalInterface
    public static interface Event {
        public int getAttemptCount();

        default public int getCauseCount() {
            return 0;
        }

        default public Throwable getCause() {
            return null;
        }
    }
}

