/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.utils;

import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;

public class RowImpl
implements Row {
    private final TSDataType[] dataTypes;
    private final int size;
    private Object[] rowRecord;

    public RowImpl(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
        this.size = dataTypes.length;
    }

    @Override
    public long getTime() {
        return (Long)this.rowRecord[this.size - 1];
    }

    @Override
    public int getInt(int columnIndex) {
        if (columnIndex >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bound error!");
        }
        return (Integer)this.rowRecord[columnIndex];
    }

    @Override
    public long getLong(int columnIndex) {
        if (columnIndex >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bound error!");
        }
        return (Long)this.rowRecord[columnIndex];
    }

    @Override
    public float getFloat(int columnIndex) {
        if (columnIndex >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bound error!");
        }
        return ((Float)this.rowRecord[columnIndex]).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) {
        if (columnIndex >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bound error!");
        }
        return (Double)this.rowRecord[columnIndex];
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        if (columnIndex >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bound error!");
        }
        return (Boolean)this.rowRecord[columnIndex];
    }

    @Override
    public org.apache.iotdb.udf.api.type.Binary getBinary(int columnIndex) {
        if (columnIndex >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bound error!");
        }
        return RowImpl.transformToUDFBinary((Binary)this.rowRecord[columnIndex]);
    }

    @Override
    public String getString(int columnIndex) {
        if (columnIndex >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bound error!");
        }
        return this.rowRecord[columnIndex].toString();
    }

    @Override
    public Type getDataType(int columnIndex) {
        return RowImpl.transformToUDFDataType(this.dataTypes[columnIndex]);
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.rowRecord[columnIndex] == null;
    }

    @Override
    public int size() {
        return this.size - 1;
    }

    public void setRowRecord(Object[] rowRecord) {
        this.rowRecord = rowRecord;
    }

    public static org.apache.iotdb.udf.api.type.Binary transformToUDFBinary(Binary binary) {
        return binary == null ? null : new org.apache.iotdb.udf.api.type.Binary(binary.getValues());
    }

    private static Type transformToUDFDataType(TSDataType tsDataType) {
        if (tsDataType == null) {
            return null;
        }
        byte type = tsDataType.getType();
        switch (type) {
            case 0: {
                return Type.BOOLEAN;
            }
            case 1: {
                return Type.INT32;
            }
            case 2: {
                return Type.INT64;
            }
            case 3: {
                return Type.FLOAT;
            }
            case 4: {
                return Type.DOUBLE;
            }
            case 5: {
                return Type.TEXT;
            }
            case 8: {
                return Type.TIMESTAMP;
            }
            case 9: {
                return Type.DATE;
            }
            case 10: {
                return Type.BLOB;
            }
            case 11: {
                return Type.STRING;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }
}

