/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CreateSessionResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=462");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=464");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=463");
    private final ResponseHeader responseHeader;
    private final NodeId sessionId;
    private final NodeId authenticationToken;
    private final Double revisedSessionTimeout;
    private final ByteString serverNonce;
    private final ByteString serverCertificate;
    private final EndpointDescription[] serverEndpoints;
    private final SignedSoftwareCertificate[] serverSoftwareCertificates;
    private final SignatureData serverSignature;
    private final UInteger maxRequestMessageSize;

    public CreateSessionResponse(ResponseHeader responseHeader, NodeId sessionId, NodeId authenticationToken, Double revisedSessionTimeout, ByteString serverNonce, ByteString serverCertificate, EndpointDescription[] serverEndpoints, SignedSoftwareCertificate[] serverSoftwareCertificates, SignatureData serverSignature, UInteger maxRequestMessageSize) {
        this.responseHeader = responseHeader;
        this.sessionId = sessionId;
        this.authenticationToken = authenticationToken;
        this.revisedSessionTimeout = revisedSessionTimeout;
        this.serverNonce = serverNonce;
        this.serverCertificate = serverCertificate;
        this.serverEndpoints = serverEndpoints;
        this.serverSoftwareCertificates = serverSoftwareCertificates;
        this.serverSignature = serverSignature;
        this.maxRequestMessageSize = maxRequestMessageSize;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public NodeId getSessionId() {
        return this.sessionId;
    }

    public NodeId getAuthenticationToken() {
        return this.authenticationToken;
    }

    public Double getRevisedSessionTimeout() {
        return this.revisedSessionTimeout;
    }

    public ByteString getServerNonce() {
        return this.serverNonce;
    }

    public ByteString getServerCertificate() {
        return this.serverCertificate;
    }

    public EndpointDescription[] getServerEndpoints() {
        return this.serverEndpoints;
    }

    public SignedSoftwareCertificate[] getServerSoftwareCertificates() {
        return this.serverSoftwareCertificates;
    }

    public SignatureData getServerSignature() {
        return this.serverSignature;
    }

    public UInteger getMaxRequestMessageSize() {
        return this.maxRequestMessageSize;
    }

    protected CreateSessionResponse(CreateSessionResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((CreateSessionResponseBuilder)b).responseHeader;
        this.sessionId = ((CreateSessionResponseBuilder)b).sessionId;
        this.authenticationToken = ((CreateSessionResponseBuilder)b).authenticationToken;
        this.revisedSessionTimeout = ((CreateSessionResponseBuilder)b).revisedSessionTimeout;
        this.serverNonce = ((CreateSessionResponseBuilder)b).serverNonce;
        this.serverCertificate = ((CreateSessionResponseBuilder)b).serverCertificate;
        this.serverEndpoints = ((CreateSessionResponseBuilder)b).serverEndpoints;
        this.serverSoftwareCertificates = ((CreateSessionResponseBuilder)b).serverSoftwareCertificates;
        this.serverSignature = ((CreateSessionResponseBuilder)b).serverSignature;
        this.maxRequestMessageSize = ((CreateSessionResponseBuilder)b).maxRequestMessageSize;
    }

    public static CreateSessionResponseBuilder<?, ?> builder() {
        return new CreateSessionResponseBuilderImpl();
    }

    public CreateSessionResponseBuilder<?, ?> toBuilder() {
        return new CreateSessionResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateSessionResponse)) {
            return false;
        }
        CreateSessionResponse other = (CreateSessionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$revisedSessionTimeout = this.getRevisedSessionTimeout();
        Double other$revisedSessionTimeout = other.getRevisedSessionTimeout();
        if (this$revisedSessionTimeout == null ? other$revisedSessionTimeout != null : !((Object)this$revisedSessionTimeout).equals(other$revisedSessionTimeout)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        NodeId this$sessionId = this.getSessionId();
        NodeId other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        NodeId this$authenticationToken = this.getAuthenticationToken();
        NodeId other$authenticationToken = other.getAuthenticationToken();
        if (this$authenticationToken == null ? other$authenticationToken != null : !((Object)this$authenticationToken).equals(other$authenticationToken)) {
            return false;
        }
        ByteString this$serverNonce = this.getServerNonce();
        ByteString other$serverNonce = other.getServerNonce();
        if (this$serverNonce == null ? other$serverNonce != null : !((Object)this$serverNonce).equals(other$serverNonce)) {
            return false;
        }
        ByteString this$serverCertificate = this.getServerCertificate();
        ByteString other$serverCertificate = other.getServerCertificate();
        if (this$serverCertificate == null ? other$serverCertificate != null : !((Object)this$serverCertificate).equals(other$serverCertificate)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getServerEndpoints(), other.getServerEndpoints())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getServerSoftwareCertificates(), other.getServerSoftwareCertificates())) {
            return false;
        }
        SignatureData this$serverSignature = this.getServerSignature();
        SignatureData other$serverSignature = other.getServerSignature();
        if (this$serverSignature == null ? other$serverSignature != null : !((Object)this$serverSignature).equals(other$serverSignature)) {
            return false;
        }
        UInteger this$maxRequestMessageSize = this.getMaxRequestMessageSize();
        UInteger other$maxRequestMessageSize = other.getMaxRequestMessageSize();
        return !(this$maxRequestMessageSize == null ? other$maxRequestMessageSize != null : !((Object)this$maxRequestMessageSize).equals(other$maxRequestMessageSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateSessionResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $revisedSessionTimeout = this.getRevisedSessionTimeout();
        result = result * 59 + ($revisedSessionTimeout == null ? 43 : ((Object)$revisedSessionTimeout).hashCode());
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        NodeId $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        NodeId $authenticationToken = this.getAuthenticationToken();
        result = result * 59 + ($authenticationToken == null ? 43 : ((Object)$authenticationToken).hashCode());
        ByteString $serverNonce = this.getServerNonce();
        result = result * 59 + ($serverNonce == null ? 43 : ((Object)$serverNonce).hashCode());
        ByteString $serverCertificate = this.getServerCertificate();
        result = result * 59 + ($serverCertificate == null ? 43 : ((Object)$serverCertificate).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getServerEndpoints());
        result = result * 59 + Arrays.deepHashCode(this.getServerSoftwareCertificates());
        SignatureData $serverSignature = this.getServerSignature();
        result = result * 59 + ($serverSignature == null ? 43 : ((Object)$serverSignature).hashCode());
        UInteger $maxRequestMessageSize = this.getMaxRequestMessageSize();
        result = result * 59 + ($maxRequestMessageSize == null ? 43 : ((Object)$maxRequestMessageSize).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CreateSessionResponse(responseHeader=" + this.getResponseHeader() + ", sessionId=" + this.getSessionId() + ", authenticationToken=" + this.getAuthenticationToken() + ", revisedSessionTimeout=" + this.getRevisedSessionTimeout() + ", serverNonce=" + this.getServerNonce() + ", serverCertificate=" + this.getServerCertificate() + ", serverEndpoints=" + Arrays.deepToString(this.getServerEndpoints()) + ", serverSoftwareCertificates=" + Arrays.deepToString(this.getServerSoftwareCertificates()) + ", serverSignature=" + this.getServerSignature() + ", maxRequestMessageSize=" + this.getMaxRequestMessageSize() + ")";
    }

    private static final class CreateSessionResponseBuilderImpl
    extends CreateSessionResponseBuilder<CreateSessionResponse, CreateSessionResponseBuilderImpl> {
        private CreateSessionResponseBuilderImpl() {
        }

        @Override
        protected CreateSessionResponseBuilderImpl self() {
            return this;
        }

        @Override
        public CreateSessionResponse build() {
            return new CreateSessionResponse(this);
        }
    }

    public static abstract class CreateSessionResponseBuilder<C extends CreateSessionResponse, B extends CreateSessionResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private NodeId sessionId;
        private NodeId authenticationToken;
        private Double revisedSessionTimeout;
        private ByteString serverNonce;
        private ByteString serverCertificate;
        private EndpointDescription[] serverEndpoints;
        private SignedSoftwareCertificate[] serverSoftwareCertificates;
        private SignatureData serverSignature;
        private UInteger maxRequestMessageSize;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CreateSessionResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CreateSessionResponse instance, CreateSessionResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.sessionId(instance.sessionId);
            b.authenticationToken(instance.authenticationToken);
            b.revisedSessionTimeout(instance.revisedSessionTimeout);
            b.serverNonce(instance.serverNonce);
            b.serverCertificate(instance.serverCertificate);
            b.serverEndpoints(instance.serverEndpoints);
            b.serverSoftwareCertificates(instance.serverSoftwareCertificates);
            b.serverSignature(instance.serverSignature);
            b.maxRequestMessageSize(instance.maxRequestMessageSize);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B sessionId(NodeId sessionId) {
            this.sessionId = sessionId;
            return (B)this.self();
        }

        public B authenticationToken(NodeId authenticationToken) {
            this.authenticationToken = authenticationToken;
            return (B)this.self();
        }

        public B revisedSessionTimeout(Double revisedSessionTimeout) {
            this.revisedSessionTimeout = revisedSessionTimeout;
            return (B)this.self();
        }

        public B serverNonce(ByteString serverNonce) {
            this.serverNonce = serverNonce;
            return (B)this.self();
        }

        public B serverCertificate(ByteString serverCertificate) {
            this.serverCertificate = serverCertificate;
            return (B)this.self();
        }

        public B serverEndpoints(EndpointDescription[] serverEndpoints) {
            this.serverEndpoints = serverEndpoints;
            return (B)this.self();
        }

        public B serverSoftwareCertificates(SignedSoftwareCertificate[] serverSoftwareCertificates) {
            this.serverSoftwareCertificates = serverSoftwareCertificates;
            return (B)this.self();
        }

        public B serverSignature(SignatureData serverSignature) {
            this.serverSignature = serverSignature;
            return (B)this.self();
        }

        public B maxRequestMessageSize(UInteger maxRequestMessageSize) {
            this.maxRequestMessageSize = maxRequestMessageSize;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CreateSessionResponse.CreateSessionResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", sessionId=" + this.sessionId + ", authenticationToken=" + this.authenticationToken + ", revisedSessionTimeout=" + this.revisedSessionTimeout + ", serverNonce=" + this.serverNonce + ", serverCertificate=" + this.serverCertificate + ", serverEndpoints=" + Arrays.deepToString(this.serverEndpoints) + ", serverSoftwareCertificates=" + Arrays.deepToString(this.serverSoftwareCertificates) + ", serverSignature=" + this.serverSignature + ", maxRequestMessageSize=" + this.maxRequestMessageSize + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CreateSessionResponse> {
        @Override
        public Class<CreateSessionResponse> getType() {
            return CreateSessionResponse.class;
        }

        @Override
        public CreateSessionResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            NodeId sessionId = decoder.readNodeId("SessionId");
            NodeId authenticationToken = decoder.readNodeId("AuthenticationToken");
            Double revisedSessionTimeout = decoder.readDouble("RevisedSessionTimeout");
            ByteString serverNonce = decoder.readByteString("ServerNonce");
            ByteString serverCertificate = decoder.readByteString("ServerCertificate");
            EndpointDescription[] serverEndpoints = (EndpointDescription[])decoder.readStructArray("ServerEndpoints", EndpointDescription.TYPE_ID);
            SignedSoftwareCertificate[] serverSoftwareCertificates = (SignedSoftwareCertificate[])decoder.readStructArray("ServerSoftwareCertificates", SignedSoftwareCertificate.TYPE_ID);
            SignatureData serverSignature = (SignatureData)decoder.readStruct("ServerSignature", SignatureData.TYPE_ID);
            UInteger maxRequestMessageSize = decoder.readUInt32("MaxRequestMessageSize");
            return new CreateSessionResponse(responseHeader, sessionId, authenticationToken, revisedSessionTimeout, serverNonce, serverCertificate, serverEndpoints, serverSoftwareCertificates, serverSignature, maxRequestMessageSize);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CreateSessionResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeNodeId("SessionId", value.getSessionId());
            encoder.writeNodeId("AuthenticationToken", value.getAuthenticationToken());
            encoder.writeDouble("RevisedSessionTimeout", value.getRevisedSessionTimeout());
            encoder.writeByteString("ServerNonce", value.getServerNonce());
            encoder.writeByteString("ServerCertificate", value.getServerCertificate());
            encoder.writeStructArray("ServerEndpoints", (Object[])value.getServerEndpoints(), EndpointDescription.TYPE_ID);
            encoder.writeStructArray("ServerSoftwareCertificates", (Object[])value.getServerSoftwareCertificates(), SignedSoftwareCertificate.TYPE_ID);
            encoder.writeStruct("ServerSignature", (Object)value.getServerSignature(), SignatureData.TYPE_ID);
            encoder.writeUInt32("MaxRequestMessageSize", value.getMaxRequestMessageSize());
        }
    }
}

