/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestType;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeSubscribeCommitReq
extends TPipeSubscribeReq {
    private transient List<SubscriptionCommitContext> commitContexts = new ArrayList<SubscriptionCommitContext>();
    private transient boolean nack;

    public List<SubscriptionCommitContext> getCommitContexts() {
        return this.commitContexts;
    }

    public boolean isNack() {
        return this.nack;
    }

    public static PipeSubscribeCommitReq toTPipeSubscribeReq(List<SubscriptionCommitContext> commitContexts, boolean nack) throws IOException {
        PipeSubscribeCommitReq req = new PipeSubscribeCommitReq();
        req.commitContexts = commitContexts;
        req.nack = nack;
        req.version = PipeSubscribeRequestVersion.VERSION_1.getVersion();
        req.type = PipeSubscribeRequestType.COMMIT.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((int)commitContexts.size(), (OutputStream)outputStream);
            for (SubscriptionCommitContext commitContext : commitContexts) {
                commitContext.serialize(outputStream);
            }
            ReadWriteIOUtils.write((Boolean)nack, (OutputStream)outputStream);
            req.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return req;
    }

    public static PipeSubscribeCommitReq fromTPipeSubscribeReq(TPipeSubscribeReq commitReq) {
        PipeSubscribeCommitReq req = new PipeSubscribeCommitReq();
        if (Objects.nonNull(commitReq.body) && commitReq.body.hasRemaining()) {
            int size = ReadWriteIOUtils.readInt((ByteBuffer)commitReq.body);
            for (int i = 0; i < size; ++i) {
                req.commitContexts.add(SubscriptionCommitContext.deserialize(commitReq.body));
            }
            req.nack = ReadWriteIOUtils.readBool((ByteBuffer)commitReq.body);
        }
        req.version = commitReq.version;
        req.type = commitReq.type;
        req.body = commitReq.body;
        return req;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribeCommitReq that = (PipeSubscribeCommitReq)((Object)obj);
        return Objects.equals(this.commitContexts, that.commitContexts) && Objects.equals(this.nack, that.nack) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.commitContexts, this.nack, this.version, this.type, this.body);
    }
}

