/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

public final class MimeConfig {
    public static final MimeConfig PERMISSIVE = MimeConfig.custom().setMaxContentLen(0x6400000L).setMaxHeaderCount(-1).setMaxHeaderLen(-1).setMaxLineLen(-1).build();
    public static final MimeConfig DEFAULT = new Builder().build();
    public static final MimeConfig STRICT = new Builder().setStrictParsing(true).setMalformedHeaderStartsBody(false).build();
    private final boolean strictParsing;
    private final int maxLineLen;
    private final int maxHeaderCount;
    private final int maxHeaderLen;
    private final long maxContentLen;
    private final boolean countLineNumbers;
    private final String headlessParsing;
    private final boolean malformedHeaderStartsBody;

    MimeConfig(boolean strictParsing, int maxLineLen, int maxHeaderCount, int maxHeaderLen, long maxContentLen, boolean countLineNumbers, String headlessParsing, boolean malformedHeaderStartsBody) {
        this.strictParsing = strictParsing;
        this.countLineNumbers = countLineNumbers;
        this.malformedHeaderStartsBody = malformedHeaderStartsBody;
        this.maxLineLen = maxLineLen;
        this.maxHeaderCount = maxHeaderCount;
        this.maxHeaderLen = maxHeaderLen;
        this.maxContentLen = maxContentLen;
        this.headlessParsing = headlessParsing;
    }

    public boolean isMalformedHeaderStartsBody() {
        return this.malformedHeaderStartsBody;
    }

    public boolean isStrictParsing() {
        return this.strictParsing;
    }

    public int getMaxLineLen() {
        return this.maxLineLen;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public int getMaxHeaderLen() {
        return this.maxHeaderLen;
    }

    public long getMaxContentLen() {
        return this.maxContentLen;
    }

    public boolean isCountLineNumbers() {
        return this.countLineNumbers;
    }

    public String getHeadlessParsing() {
        return this.headlessParsing;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[strictParsing=").append(this.strictParsing).append(", maxLineLen=").append(this.maxLineLen).append(", maxHeaderCount=").append(this.maxHeaderCount).append(", maxHeaderLen=").append(this.maxHeaderLen).append(", maxContentLen=").append(this.maxContentLen).append(", countLineNumbers=").append(this.countLineNumbers).append(", headlessParsing=").append(this.headlessParsing).append(", malformedHeaderStartsBody=").append(this.malformedHeaderStartsBody).append("]");
        return b.toString();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(MimeConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config may not be null");
        }
        return new Builder().setStrictParsing(config.isStrictParsing()).setMaxLineLen(config.getMaxLineLen()).setMaxHeaderCount(config.getMaxHeaderCount()).setMaxHeaderLen(config.getMaxHeaderLen()).setMaxContentLen(config.getMaxContentLen()).setCountLineNumbers(config.isCountLineNumbers()).setHeadlessParsing(config.getHeadlessParsing()).setMalformedHeaderStartsBody(config.isMalformedHeaderStartsBody());
    }

    public static class Builder {
        private boolean strictParsing = false;
        private int maxLineLen = 1000;
        private int maxHeaderCount = 1000;
        private int maxHeaderLen = 10000;
        private long maxContentLen = -1L;
        private boolean countLineNumbers = false;
        private String headlessParsing = null;
        private boolean malformedHeaderStartsBody = false;

        public Builder setMalformedHeaderStartsBody(boolean malformedHeaderStartsBody) {
            this.malformedHeaderStartsBody = malformedHeaderStartsBody;
            return this;
        }

        public Builder setStrictParsing(boolean strictParsing) {
            this.strictParsing = strictParsing;
            return this;
        }

        public Builder setMaxLineLen(int maxLineLen) {
            this.maxLineLen = maxLineLen;
            return this;
        }

        public Builder setMaxHeaderCount(int maxHeaderCount) {
            this.maxHeaderCount = maxHeaderCount;
            return this;
        }

        public Builder setMaxHeaderLen(int maxHeaderLen) {
            this.maxHeaderLen = maxHeaderLen;
            return this;
        }

        public Builder setMaxContentLen(long maxContentLen) {
            this.maxContentLen = maxContentLen;
            return this;
        }

        public Builder setCountLineNumbers(boolean countLineNumbers) {
            this.countLineNumbers = countLineNumbers;
            return this;
        }

        public Builder setHeadlessParsing(String contentType) {
            this.headlessParsing = contentType;
            return this;
        }

        public MimeConfig build() {
            return new MimeConfig(this.strictParsing, this.maxLineLen, this.maxHeaderCount, this.maxHeaderLen, this.maxContentLen, this.countLineNumbers, this.headlessParsing, this.malformedHeaderStartsBody);
        }
    }
}

