/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.incubator.codec.quic.QuicConnectionIdGenerator;
import io.netty.incubator.codec.quic.Quiche;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.security.SecureRandom;

final class SecureRandomQuicConnectionIdGenerator
implements QuicConnectionIdGenerator {
    private static final SecureRandom RANDOM = new SecureRandom();
    static final QuicConnectionIdGenerator INSTANCE = new SecureRandomQuicConnectionIdGenerator();

    private SecureRandomQuicConnectionIdGenerator() {
    }

    @Override
    public ByteBuffer newId(int length) {
        ObjectUtil.checkInRange((int)length, (int)0, (int)this.maxConnectionIdLength(), (String)"length");
        byte[] bytes = new byte[length];
        RANDOM.nextBytes(bytes);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public ByteBuffer newId(ByteBuffer buffer, int length) {
        return this.newId(length);
    }

    @Override
    public int maxConnectionIdLength() {
        return Quiche.QUICHE_MAX_CONN_ID_LEN;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }
}

