/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.MetadataResponse;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataResponseEncoder
implements ImapResponseEncoder<MetadataResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataResponseEncoder.class);

    @Override
    public Class<MetadataResponse> acceptableMessages() {
        return MetadataResponse.class;
    }

    @Override
    public void encode(MetadataResponse response, ImapResponseComposer composer) throws IOException {
        composer.untagged();
        composer.message("METADATA");
        composer.mailbox(Optional.ofNullable(response.getMailboxName()).orElse(""));
        this.composeAnnotations(composer, response.getMailboxAnnotations());
        composer.end();
    }

    private void composeAnnotations(ImapResponseComposer composer, List<MailboxAnnotation> annotations) throws IOException {
        if (!annotations.isEmpty()) {
            composer.openParen();
            for (MailboxAnnotation annotation : annotations) {
                this.composeAnnotation(composer, annotation);
            }
            composer.closeParen();
        }
    }

    private void composeAnnotation(ImapResponseComposer composer, MailboxAnnotation annotation) throws IOException {
        if (annotation.isNil()) {
            LOGGER.warn("There is nil data of key {} on store: ", (Object)annotation.getKey().asString());
        } else {
            composer.message(annotation.getKey().asString());
            composer.quote(annotation.getValue().orElse(""));
        }
    }
}

