/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public final class XmlUtil {
    private static final String ALL_TEXT_NODES = "//text()";
    private static final Logger LOG = LogManager.getLogger(XmlUtil.class);

    private XmlUtil() {
    }

    public static List<Element> parse(String xml, String requestedNodes) {
        if (StringUtils.isNotEmpty((CharSequence)xml) && StringUtils.isNotEmpty((CharSequence)requestedNodes)) {
            HashSet readed = new HashSet();
            SAXBuilder builder = new SAXBuilder();
            try {
                Enumeration<URL> resources = XmlUtil.class.getClassLoader().getResources(xml);
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    LOG.debug("reading {}", (Object)resource.toString());
                    Document doc = builder.build(resource);
                    XPathFactory xpfac = XPathFactory.instance();
                    XPathExpression xp = xpfac.compile(requestedNodes, Filters.element());
                    readed.addAll(xp.evaluate((Object)doc));
                }
                return new ArrayList<Element>(readed);
            }
            catch (IOException ioe) {
                LOG.error("Couldn't load all {} resources", (Object)xml, (Object)ioe);
            }
            catch (JDOMException jdome) {
                LOG.error("error parsing {} resources", (Object)xml, (Object)jdome);
            }
        }
        return Collections.emptyList();
    }

    public static List<Element> parse(InputStream xmlStream, String requestedNodes) {
        if (xmlStream != null && StringUtils.isNotEmpty((CharSequence)requestedNodes)) {
            SAXBuilder builder = new SAXBuilder();
            try {
                Document doc = builder.build(xmlStream);
                XPathFactory xpfac = XPathFactory.instance();
                XPathExpression xp = xpfac.compile(requestedNodes, Filters.element());
                return xp.evaluate((Object)doc);
            }
            catch (IOException ioe) {
                LOG.error("Couldn't load all {} resources", (Object)xmlStream, (Object)ioe);
            }
            catch (JDOMException jdome) {
                LOG.error("error parsing {} resources", (Object)xmlStream, (Object)jdome);
            }
        }
        return Collections.emptyList();
    }

    public static String extractTextFromDocument(Document doc) {
        if (doc == null) {
            return "";
        }
        List nodes = XPathFactory.instance().compile(ALL_TEXT_NODES).evaluate((Object)doc);
        String sb = nodes.stream().filter(el -> el instanceof Text).map(el -> ((Text)el).getValue()).collect(Collectors.joining());
        return sb;
    }

    public static Element getXPathElement(Element base, String expression) {
        List nodes = XPathFactory.instance().compile(expression).evaluate((Object)base);
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        return (Element)nodes.get(0);
    }
}

