/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.DataSourceVpcConfiguration;
import com.amazonaws.services.kendra.model.SlackEntity;
import com.amazonaws.services.kendra.model.transform.SlackConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SlackConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String teamId;
    private String secretArn;
    private DataSourceVpcConfiguration vpcConfiguration;
    private List<String> slackEntityList;
    private Boolean useChangeLog;
    private Boolean crawlBotMessage;
    private Boolean excludeArchived;
    private String sinceCrawlDate;
    private Integer lookBackPeriod;
    private List<String> privateChannelFilter;
    private List<String> publicChannelFilter;
    private List<String> inclusionPatterns;
    private List<String> exclusionPatterns;
    private List<DataSourceToIndexFieldMapping> fieldMappings;

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public SlackConfiguration withTeamId(String teamId) {
        this.setTeamId(teamId);
        return this;
    }

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    public String getSecretArn() {
        return this.secretArn;
    }

    public SlackConfiguration withSecretArn(String secretArn) {
        this.setSecretArn(secretArn);
        return this;
    }

    public void setVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.vpcConfiguration = vpcConfiguration;
    }

    public DataSourceVpcConfiguration getVpcConfiguration() {
        return this.vpcConfiguration;
    }

    public SlackConfiguration withVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.setVpcConfiguration(vpcConfiguration);
        return this;
    }

    public List<String> getSlackEntityList() {
        return this.slackEntityList;
    }

    public void setSlackEntityList(Collection<String> slackEntityList) {
        if (slackEntityList == null) {
            this.slackEntityList = null;
            return;
        }
        this.slackEntityList = new ArrayList<String>(slackEntityList);
    }

    public SlackConfiguration withSlackEntityList(String ... slackEntityList) {
        if (this.slackEntityList == null) {
            this.setSlackEntityList(new ArrayList<String>(slackEntityList.length));
        }
        for (String ele : slackEntityList) {
            this.slackEntityList.add(ele);
        }
        return this;
    }

    public SlackConfiguration withSlackEntityList(Collection<String> slackEntityList) {
        this.setSlackEntityList(slackEntityList);
        return this;
    }

    public SlackConfiguration withSlackEntityList(SlackEntity ... slackEntityList) {
        ArrayList<String> slackEntityListCopy = new ArrayList<String>(slackEntityList.length);
        for (SlackEntity value : slackEntityList) {
            slackEntityListCopy.add(value.toString());
        }
        if (this.getSlackEntityList() == null) {
            this.setSlackEntityList(slackEntityListCopy);
        } else {
            this.getSlackEntityList().addAll(slackEntityListCopy);
        }
        return this;
    }

    public void setUseChangeLog(Boolean useChangeLog) {
        this.useChangeLog = useChangeLog;
    }

    public Boolean getUseChangeLog() {
        return this.useChangeLog;
    }

    public SlackConfiguration withUseChangeLog(Boolean useChangeLog) {
        this.setUseChangeLog(useChangeLog);
        return this;
    }

    public Boolean isUseChangeLog() {
        return this.useChangeLog;
    }

    public void setCrawlBotMessage(Boolean crawlBotMessage) {
        this.crawlBotMessage = crawlBotMessage;
    }

    public Boolean getCrawlBotMessage() {
        return this.crawlBotMessage;
    }

    public SlackConfiguration withCrawlBotMessage(Boolean crawlBotMessage) {
        this.setCrawlBotMessage(crawlBotMessage);
        return this;
    }

    public Boolean isCrawlBotMessage() {
        return this.crawlBotMessage;
    }

    public void setExcludeArchived(Boolean excludeArchived) {
        this.excludeArchived = excludeArchived;
    }

    public Boolean getExcludeArchived() {
        return this.excludeArchived;
    }

    public SlackConfiguration withExcludeArchived(Boolean excludeArchived) {
        this.setExcludeArchived(excludeArchived);
        return this;
    }

    public Boolean isExcludeArchived() {
        return this.excludeArchived;
    }

    public void setSinceCrawlDate(String sinceCrawlDate) {
        this.sinceCrawlDate = sinceCrawlDate;
    }

    public String getSinceCrawlDate() {
        return this.sinceCrawlDate;
    }

    public SlackConfiguration withSinceCrawlDate(String sinceCrawlDate) {
        this.setSinceCrawlDate(sinceCrawlDate);
        return this;
    }

    public void setLookBackPeriod(Integer lookBackPeriod) {
        this.lookBackPeriod = lookBackPeriod;
    }

    public Integer getLookBackPeriod() {
        return this.lookBackPeriod;
    }

    public SlackConfiguration withLookBackPeriod(Integer lookBackPeriod) {
        this.setLookBackPeriod(lookBackPeriod);
        return this;
    }

    public List<String> getPrivateChannelFilter() {
        return this.privateChannelFilter;
    }

    public void setPrivateChannelFilter(Collection<String> privateChannelFilter) {
        if (privateChannelFilter == null) {
            this.privateChannelFilter = null;
            return;
        }
        this.privateChannelFilter = new ArrayList<String>(privateChannelFilter);
    }

    public SlackConfiguration withPrivateChannelFilter(String ... privateChannelFilter) {
        if (this.privateChannelFilter == null) {
            this.setPrivateChannelFilter(new ArrayList<String>(privateChannelFilter.length));
        }
        for (String ele : privateChannelFilter) {
            this.privateChannelFilter.add(ele);
        }
        return this;
    }

    public SlackConfiguration withPrivateChannelFilter(Collection<String> privateChannelFilter) {
        this.setPrivateChannelFilter(privateChannelFilter);
        return this;
    }

    public List<String> getPublicChannelFilter() {
        return this.publicChannelFilter;
    }

    public void setPublicChannelFilter(Collection<String> publicChannelFilter) {
        if (publicChannelFilter == null) {
            this.publicChannelFilter = null;
            return;
        }
        this.publicChannelFilter = new ArrayList<String>(publicChannelFilter);
    }

    public SlackConfiguration withPublicChannelFilter(String ... publicChannelFilter) {
        if (this.publicChannelFilter == null) {
            this.setPublicChannelFilter(new ArrayList<String>(publicChannelFilter.length));
        }
        for (String ele : publicChannelFilter) {
            this.publicChannelFilter.add(ele);
        }
        return this;
    }

    public SlackConfiguration withPublicChannelFilter(Collection<String> publicChannelFilter) {
        this.setPublicChannelFilter(publicChannelFilter);
        return this;
    }

    public List<String> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public void setInclusionPatterns(Collection<String> inclusionPatterns) {
        if (inclusionPatterns == null) {
            this.inclusionPatterns = null;
            return;
        }
        this.inclusionPatterns = new ArrayList<String>(inclusionPatterns);
    }

    public SlackConfiguration withInclusionPatterns(String ... inclusionPatterns) {
        if (this.inclusionPatterns == null) {
            this.setInclusionPatterns(new ArrayList<String>(inclusionPatterns.length));
        }
        for (String ele : inclusionPatterns) {
            this.inclusionPatterns.add(ele);
        }
        return this;
    }

    public SlackConfiguration withInclusionPatterns(Collection<String> inclusionPatterns) {
        this.setInclusionPatterns(inclusionPatterns);
        return this;
    }

    public List<String> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public void setExclusionPatterns(Collection<String> exclusionPatterns) {
        if (exclusionPatterns == null) {
            this.exclusionPatterns = null;
            return;
        }
        this.exclusionPatterns = new ArrayList<String>(exclusionPatterns);
    }

    public SlackConfiguration withExclusionPatterns(String ... exclusionPatterns) {
        if (this.exclusionPatterns == null) {
            this.setExclusionPatterns(new ArrayList<String>(exclusionPatterns.length));
        }
        for (String ele : exclusionPatterns) {
            this.exclusionPatterns.add(ele);
        }
        return this;
    }

    public SlackConfiguration withExclusionPatterns(Collection<String> exclusionPatterns) {
        this.setExclusionPatterns(exclusionPatterns);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        if (fieldMappings == null) {
            this.fieldMappings = null;
            return;
        }
        this.fieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings);
    }

    public SlackConfiguration withFieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
        if (this.fieldMappings == null) {
            this.setFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : fieldMappings) {
            this.fieldMappings.add(ele);
        }
        return this;
    }

    public SlackConfiguration withFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        this.setFieldMappings(fieldMappings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTeamId() != null) {
            sb.append("TeamId: ").append(this.getTeamId()).append(",");
        }
        if (this.getSecretArn() != null) {
            sb.append("SecretArn: ").append(this.getSecretArn()).append(",");
        }
        if (this.getVpcConfiguration() != null) {
            sb.append("VpcConfiguration: ").append(this.getVpcConfiguration()).append(",");
        }
        if (this.getSlackEntityList() != null) {
            sb.append("SlackEntityList: ").append(this.getSlackEntityList()).append(",");
        }
        if (this.getUseChangeLog() != null) {
            sb.append("UseChangeLog: ").append(this.getUseChangeLog()).append(",");
        }
        if (this.getCrawlBotMessage() != null) {
            sb.append("CrawlBotMessage: ").append(this.getCrawlBotMessage()).append(",");
        }
        if (this.getExcludeArchived() != null) {
            sb.append("ExcludeArchived: ").append(this.getExcludeArchived()).append(",");
        }
        if (this.getSinceCrawlDate() != null) {
            sb.append("SinceCrawlDate: ").append(this.getSinceCrawlDate()).append(",");
        }
        if (this.getLookBackPeriod() != null) {
            sb.append("LookBackPeriod: ").append(this.getLookBackPeriod()).append(",");
        }
        if (this.getPrivateChannelFilter() != null) {
            sb.append("PrivateChannelFilter: ").append(this.getPrivateChannelFilter()).append(",");
        }
        if (this.getPublicChannelFilter() != null) {
            sb.append("PublicChannelFilter: ").append(this.getPublicChannelFilter()).append(",");
        }
        if (this.getInclusionPatterns() != null) {
            sb.append("InclusionPatterns: ").append(this.getInclusionPatterns()).append(",");
        }
        if (this.getExclusionPatterns() != null) {
            sb.append("ExclusionPatterns: ").append(this.getExclusionPatterns()).append(",");
        }
        if (this.getFieldMappings() != null) {
            sb.append("FieldMappings: ").append(this.getFieldMappings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlackConfiguration)) {
            return false;
        }
        SlackConfiguration other = (SlackConfiguration)obj;
        if (other.getTeamId() == null ^ this.getTeamId() == null) {
            return false;
        }
        if (other.getTeamId() != null && !other.getTeamId().equals(this.getTeamId())) {
            return false;
        }
        if (other.getSecretArn() == null ^ this.getSecretArn() == null) {
            return false;
        }
        if (other.getSecretArn() != null && !other.getSecretArn().equals(this.getSecretArn())) {
            return false;
        }
        if (other.getVpcConfiguration() == null ^ this.getVpcConfiguration() == null) {
            return false;
        }
        if (other.getVpcConfiguration() != null && !other.getVpcConfiguration().equals(this.getVpcConfiguration())) {
            return false;
        }
        if (other.getSlackEntityList() == null ^ this.getSlackEntityList() == null) {
            return false;
        }
        if (other.getSlackEntityList() != null && !other.getSlackEntityList().equals(this.getSlackEntityList())) {
            return false;
        }
        if (other.getUseChangeLog() == null ^ this.getUseChangeLog() == null) {
            return false;
        }
        if (other.getUseChangeLog() != null && !other.getUseChangeLog().equals(this.getUseChangeLog())) {
            return false;
        }
        if (other.getCrawlBotMessage() == null ^ this.getCrawlBotMessage() == null) {
            return false;
        }
        if (other.getCrawlBotMessage() != null && !other.getCrawlBotMessage().equals(this.getCrawlBotMessage())) {
            return false;
        }
        if (other.getExcludeArchived() == null ^ this.getExcludeArchived() == null) {
            return false;
        }
        if (other.getExcludeArchived() != null && !other.getExcludeArchived().equals(this.getExcludeArchived())) {
            return false;
        }
        if (other.getSinceCrawlDate() == null ^ this.getSinceCrawlDate() == null) {
            return false;
        }
        if (other.getSinceCrawlDate() != null && !other.getSinceCrawlDate().equals(this.getSinceCrawlDate())) {
            return false;
        }
        if (other.getLookBackPeriod() == null ^ this.getLookBackPeriod() == null) {
            return false;
        }
        if (other.getLookBackPeriod() != null && !other.getLookBackPeriod().equals(this.getLookBackPeriod())) {
            return false;
        }
        if (other.getPrivateChannelFilter() == null ^ this.getPrivateChannelFilter() == null) {
            return false;
        }
        if (other.getPrivateChannelFilter() != null && !other.getPrivateChannelFilter().equals(this.getPrivateChannelFilter())) {
            return false;
        }
        if (other.getPublicChannelFilter() == null ^ this.getPublicChannelFilter() == null) {
            return false;
        }
        if (other.getPublicChannelFilter() != null && !other.getPublicChannelFilter().equals(this.getPublicChannelFilter())) {
            return false;
        }
        if (other.getInclusionPatterns() == null ^ this.getInclusionPatterns() == null) {
            return false;
        }
        if (other.getInclusionPatterns() != null && !other.getInclusionPatterns().equals(this.getInclusionPatterns())) {
            return false;
        }
        if (other.getExclusionPatterns() == null ^ this.getExclusionPatterns() == null) {
            return false;
        }
        if (other.getExclusionPatterns() != null && !other.getExclusionPatterns().equals(this.getExclusionPatterns())) {
            return false;
        }
        if (other.getFieldMappings() == null ^ this.getFieldMappings() == null) {
            return false;
        }
        return other.getFieldMappings() == null || other.getFieldMappings().equals(this.getFieldMappings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTeamId() == null ? 0 : this.getTeamId().hashCode());
        hashCode = 31 * hashCode + (this.getSecretArn() == null ? 0 : this.getSecretArn().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfiguration() == null ? 0 : this.getVpcConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getSlackEntityList() == null ? 0 : this.getSlackEntityList().hashCode());
        hashCode = 31 * hashCode + (this.getUseChangeLog() == null ? 0 : this.getUseChangeLog().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlBotMessage() == null ? 0 : this.getCrawlBotMessage().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeArchived() == null ? 0 : this.getExcludeArchived().hashCode());
        hashCode = 31 * hashCode + (this.getSinceCrawlDate() == null ? 0 : this.getSinceCrawlDate().hashCode());
        hashCode = 31 * hashCode + (this.getLookBackPeriod() == null ? 0 : this.getLookBackPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateChannelFilter() == null ? 0 : this.getPrivateChannelFilter().hashCode());
        hashCode = 31 * hashCode + (this.getPublicChannelFilter() == null ? 0 : this.getPublicChannelFilter().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionPatterns() == null ? 0 : this.getInclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getExclusionPatterns() == null ? 0 : this.getExclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getFieldMappings() == null ? 0 : this.getFieldMappings().hashCode());
        return hashCode;
    }

    public SlackConfiguration clone() {
        try {
            return (SlackConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SlackConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

