/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DocumentAttribute;
import com.amazonaws.services.kendra.model.transform.SourceDocumentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SourceDocument
implements Serializable,
Cloneable,
StructuredPojo {
    private String documentId;
    private List<String> suggestionAttributes;
    private List<DocumentAttribute> additionalAttributes;

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public SourceDocument withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public List<String> getSuggestionAttributes() {
        return this.suggestionAttributes;
    }

    public void setSuggestionAttributes(Collection<String> suggestionAttributes) {
        if (suggestionAttributes == null) {
            this.suggestionAttributes = null;
            return;
        }
        this.suggestionAttributes = new ArrayList<String>(suggestionAttributes);
    }

    public SourceDocument withSuggestionAttributes(String ... suggestionAttributes) {
        if (this.suggestionAttributes == null) {
            this.setSuggestionAttributes(new ArrayList<String>(suggestionAttributes.length));
        }
        for (String ele : suggestionAttributes) {
            this.suggestionAttributes.add(ele);
        }
        return this;
    }

    public SourceDocument withSuggestionAttributes(Collection<String> suggestionAttributes) {
        this.setSuggestionAttributes(suggestionAttributes);
        return this;
    }

    public List<DocumentAttribute> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public void setAdditionalAttributes(Collection<DocumentAttribute> additionalAttributes) {
        if (additionalAttributes == null) {
            this.additionalAttributes = null;
            return;
        }
        this.additionalAttributes = new ArrayList<DocumentAttribute>(additionalAttributes);
    }

    public SourceDocument withAdditionalAttributes(DocumentAttribute ... additionalAttributes) {
        if (this.additionalAttributes == null) {
            this.setAdditionalAttributes(new ArrayList<DocumentAttribute>(additionalAttributes.length));
        }
        for (DocumentAttribute ele : additionalAttributes) {
            this.additionalAttributes.add(ele);
        }
        return this;
    }

    public SourceDocument withAdditionalAttributes(Collection<DocumentAttribute> additionalAttributes) {
        this.setAdditionalAttributes(additionalAttributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentId() != null) {
            sb.append("DocumentId: ").append(this.getDocumentId()).append(",");
        }
        if (this.getSuggestionAttributes() != null) {
            sb.append("SuggestionAttributes: ").append(this.getSuggestionAttributes()).append(",");
        }
        if (this.getAdditionalAttributes() != null) {
            sb.append("AdditionalAttributes: ").append(this.getAdditionalAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDocument)) {
            return false;
        }
        SourceDocument other = (SourceDocument)obj;
        if (other.getDocumentId() == null ^ this.getDocumentId() == null) {
            return false;
        }
        if (other.getDocumentId() != null && !other.getDocumentId().equals(this.getDocumentId())) {
            return false;
        }
        if (other.getSuggestionAttributes() == null ^ this.getSuggestionAttributes() == null) {
            return false;
        }
        if (other.getSuggestionAttributes() != null && !other.getSuggestionAttributes().equals(this.getSuggestionAttributes())) {
            return false;
        }
        if (other.getAdditionalAttributes() == null ^ this.getAdditionalAttributes() == null) {
            return false;
        }
        return other.getAdditionalAttributes() == null || other.getAdditionalAttributes().equals(this.getAdditionalAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentId() == null ? 0 : this.getDocumentId().hashCode());
        hashCode = 31 * hashCode + (this.getSuggestionAttributes() == null ? 0 : this.getSuggestionAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalAttributes() == null ? 0 : this.getAdditionalAttributes().hashCode());
        return hashCode;
    }

    public SourceDocument clone() {
        try {
            return (SourceDocument)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

