/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.recorders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.internal.hppc.IntCursor;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.sandbox.facet.cutters.FacetCutter;
import org.apache.lucene.sandbox.facet.iterators.OrdinalIterator;
import org.apache.lucene.sandbox.facet.recorders.FacetRecorder;
import org.apache.lucene.sandbox.facet.recorders.LeafFacetRecorder;
import org.apache.lucene.sandbox.facet.recorders.Reducer;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;

public final class LongAggregationsFacetRecorder
implements FacetRecorder {
    private IntObjectHashMap<long[]> values;
    private final List<IntObjectHashMap<long[]>> leafValues;
    private final LongValuesSource[] longValuesSources;
    private final Reducer[] reducers;

    public LongAggregationsFacetRecorder(LongValuesSource[] longValuesSources, Reducer[] reducers) {
        assert (longValuesSources.length == reducers.length);
        this.longValuesSources = longValuesSources;
        this.reducers = reducers;
        this.leafValues = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public LeafFacetRecorder getLeafRecorder(LeafReaderContext context) throws IOException {
        LongValues[] longValues = new LongValues[this.longValuesSources.length];
        for (int i = 0; i < this.longValuesSources.length; ++i) {
            longValues[i] = this.longValuesSources[i].getValues(context, null);
        }
        IntObjectHashMap valuesRecorder = new IntObjectHashMap();
        this.leafValues.add((IntObjectHashMap<long[]>)valuesRecorder);
        return new LongAggregationsLeafFacetRecorder(longValues, this.reducers, (IntObjectHashMap<long[]>)valuesRecorder);
    }

    @Override
    public OrdinalIterator recordedOrds() {
        final Iterator ordIterator = this.values.keys().iterator();
        return new OrdinalIterator(){

            @Override
            public int nextOrd() throws IOException {
                if (ordIterator.hasNext()) {
                    return ((IntCursor)ordIterator.next()).value;
                }
                return -1;
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public void reduce(FacetCutter facetCutter) throws IOException {
        OrdinalIterator dimOrds;
        boolean firstElement = true;
        for (IntObjectHashMap<long[]> leafValue : this.leafValues) {
            if (firstElement) {
                this.values = leafValue;
                firstElement = false;
                continue;
            }
            for (IntObjectHashMap.IntObjectCursor elem : leafValue) {
                long[] vals = (long[])this.values.get(elem.key);
                if (vals == null) {
                    this.values.put(elem.key, (Object)((long[])elem.value));
                    continue;
                }
                for (int i = 0; i < this.longValuesSources.length; ++i) {
                    vals[i] = this.reducers[i].reduce(vals[i], ((long[])elem.value)[i]);
                }
            }
        }
        if (firstElement) {
            this.values = new IntObjectHashMap();
        }
        if ((dimOrds = facetCutter.getOrdinalsToRollup()) != null) {
            int dimOrd = dimOrds.nextOrd();
            while (dimOrd != -1) {
                this.rollup((long[])this.values.get(dimOrd), dimOrd, facetCutter);
                dimOrd = dimOrds.nextOrd();
            }
        }
    }

    @Override
    public boolean contains(int ordinal) {
        return this.values.containsKey(ordinal);
    }

    private long[] rollup(long[] accum, int ord, FacetCutter facetCutter) throws IOException {
        OrdinalIterator childOrds = facetCutter.getChildrenOrds(ord);
        int nextChild = childOrds.nextOrd();
        while (nextChild != -1) {
            long[] current = this.rollup((long[])this.values.get(nextChild), nextChild, facetCutter);
            if (current != null) {
                if (accum == null) {
                    accum = new long[this.longValuesSources.length];
                    this.values.put(ord, (Object)accum);
                }
                for (int i = 0; i < this.longValuesSources.length; ++i) {
                    accum[i] = this.reducers[i].reduce(accum[i], current[i]);
                }
            }
            nextChild = childOrds.nextOrd();
        }
        return accum;
    }

    public long getRecordedValue(int ord, int valuesId) {
        if (valuesId < 0 || valuesId >= this.longValuesSources.length) {
            throw new IllegalArgumentException("Invalid request for ordinal values");
        }
        long[] valuesForOrd = (long[])this.values.get(ord);
        if (valuesForOrd != null) {
            return valuesForOrd[valuesId];
        }
        return 0L;
    }

    private static class LongAggregationsLeafFacetRecorder
    implements LeafFacetRecorder {
        private final LongValues[] longValues;
        private final Reducer[] reducers;
        private final IntObjectHashMap<long[]> perOrdinalValues;

        LongAggregationsLeafFacetRecorder(LongValues[] longValues, Reducer[] reducers, IntObjectHashMap<long[]> perOrdinalValues) {
            this.longValues = longValues;
            this.reducers = reducers;
            this.perOrdinalValues = perOrdinalValues;
        }

        @Override
        public void record(int docId, int facetOrd) throws IOException {
            long[] valuesForOrd = (long[])this.perOrdinalValues.get(facetOrd);
            if (valuesForOrd == null) {
                valuesForOrd = new long[this.longValues.length];
                this.perOrdinalValues.put(facetOrd, (Object)valuesForOrd);
            }
            for (int i = 0; i < this.longValues.length; ++i) {
                LongValues values = this.longValues[i];
                if (!values.advanceExact(docId)) continue;
                valuesForOrd[i] = this.reducers[i].reduce(valuesForOrd[i], values.longValue());
            }
        }
    }
}

