/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.exceptions.NoSuchVariableException;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorStateCommonOperations;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.WikiHtmlInline;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.variables.VariableManager;

public class VariableLinkNodePostProcessorState
implements NodePostProcessorState<JSPWikiLink> {
    private final Context wikiContext;
    private final boolean m_wysiwygEditorMode;

    public VariableLinkNodePostProcessorState(Context wikiContext) {
        this.wikiContext = wikiContext;
        Boolean wysiwygVariable = (Boolean)wikiContext.getVariable("WYSIWYG_EDITOR_MODE");
        this.m_wysiwygEditorMode = wysiwygVariable != null && wysiwygVariable != false;
    }

    @Override
    public void process(NodeTracker state, JSPWikiLink link) {
        String variable = NodePostProcessorStateCommonOperations.inlineLinkTextOnWysiwyg(state, link, this.m_wysiwygEditorMode);
        if (!this.m_wysiwygEditorMode) {
            try {
                String parsedVariable = ((VariableManager)this.wikiContext.getEngine().getManager(VariableManager.class)).parseAndGetValue(this.wikiContext, variable);
                WikiHtmlInline content = WikiHtmlInline.of(parsedVariable, this.wikiContext);
                NodePostProcessorStateCommonOperations.addContent(state, (Node)link, (Node)content);
            }
            catch (NoSuchVariableException e) {
                NodePostProcessorStateCommonOperations.makeError(state, (Node)link, "No such variable: " + variable + " (" + e.getMessage() + ")");
            }
        }
    }
}

