/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.toc.SimTocContent;
import com.vladsch.flexmark.ext.toc.SimTocExtension;
import com.vladsch.flexmark.ext.toc.TocBlock;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.ext.toc.internal.SimTocOptionsParser;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.ext.toc.internal.TocOptionsParser;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.TextCollectingVisitor;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.misc.DelimitedBuilder;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.misc.Paired;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class TocUtils {
    public static final AttributablePart TOC_CONTENT = new AttributablePart("TOC_CONTENT");
    public static final AttributablePart TOC_LIST = new AttributablePart("TOC_LIST");

    public static String getTocPrefix(TocOptions options, TocOptions defaultOptions) {
        DelimitedBuilder out = new DelimitedBuilder(" ");
        out.append("[TOC").mark();
        TocOptionsParser optionsParser = new TocOptionsParser();
        out.append(optionsParser.getOptionText(options, defaultOptions));
        out.unmark().append("]");
        out.append("\n").unmark();
        return out.toString();
    }

    public static String getSimTocPrefix(TocOptions options, TocOptions defaultOptions) {
        DelimitedBuilder out = new DelimitedBuilder(" ");
        out.append("[TOC").mark();
        SimTocOptionsParser optionsParser = new SimTocOptionsParser();
        out.append(optionsParser.getOptionText(options, defaultOptions));
        out.unmark().append("]:").mark().append('#').mark();
        String optionTitleHeading = options.getTitleHeading();
        String optionTitle = options.title;
        if (defaultOptions == null || !optionTitleHeading.equals(defaultOptions.getTitleHeading())) {
            if (!optionTitle.isEmpty()) {
                out.append('\"');
                if (defaultOptions == null || options.titleLevel != defaultOptions.titleLevel) {
                    out.append(optionTitleHeading.trim().replace("\\", "\\\\").replace("\"", "\\\""));
                } else {
                    out.append(optionTitle.trim().replace("\\", "\\\\").replace("\"", "\\\""));
                }
                out.append('\"').mark();
            } else {
                out.append("\"\"").mark();
            }
        }
        out.unmark().append("\n").unmark();
        return out.toString();
    }

    public static void renderTocContent(MarkdownWriter markdown, TocOptions options, TocOptions defaultOptions, List<Heading> headings, List<String> headingTexts) {
        if (headings.isEmpty()) {
            return;
        }
        Document document = headings.get(0).getDocument();
        if (options.isHtml) {
            MarkdownWriter out = new MarkdownWriter(markdown.getOptions());
            for (Heading heading : headings) {
                ((MarkdownWriter)out.append((CharSequence)heading.getChars())).line();
            }
            out.append((CharSequence)TocUtils.getTocPrefix(options, defaultOptions));
            MutableDataSet options1 = new MutableDataSet((DataHolder)document);
            defaultOptions.setIn((MutableDataHolder)options1);
            options.setIn((MutableDataHolder)options1);
            if (!options1.contains((DataKeyBase)HtmlRenderer.INDENT_SIZE)) {
                options1.set(HtmlRenderer.INDENT_SIZE, (Object)2);
            }
            options1.set(HtmlRenderer.RENDER_HEADER_ID, (Object)false);
            options1.set(HtmlRenderer.GENERATE_HEADER_ID, (Object)false);
            ArrayList<Object> extensions = new ArrayList<Object>((Collection)Parser.EXTENSIONS.get((DataHolder)options1));
            extensions.removeIf(extension -> extension instanceof SimTocExtension);
            extensions.add(TocExtension.create());
            options1.set(Parser.EXTENSIONS, extensions);
            Parser parser = Parser.builder((DataHolder)options1).build();
            HtmlRenderer htmlRenderer = HtmlRenderer.builder((DataHolder)options1).build();
            Document tocDocument = parser.parse(out.toString());
            int i = 0;
            for (Node node : tocDocument.getChildren()) {
                if (!(node instanceof Heading)) continue;
                ((Heading)node).setAnchorRefId(headings.get(i).getAnchorRefId());
                ++i;
            }
            Node toc = tocDocument.getFirstChildAny(new Class[]{TocBlock.class});
            assert (toc != null);
            markdown.openPreFormatted(false);
            htmlRenderer.render(toc, (Appendable)markdown);
            markdown.closePreFormatted();
        } else {
            String heading = options.getTitleHeading();
            if (!heading.isEmpty()) {
                markdown.append((CharSequence)heading);
            }
            if (((ParserEmulationProfile)Parser.PARSER_EMULATION_PROFILE.get((DataHolder)document)).family == ParserEmulationProfile.FIXED_INDENT) {
                markdown.setIndentPrefix(RepeatedSequence.ofSpaces((int)4));
            } else {
                markdown.setIndentPrefix(RepeatedSequence.ofSpaces((int)(options.isNumbered ? 3 : 2)));
            }
            TocUtils.renderMarkdownToc(markdown, headings.stream().map(Heading::getLevel).collect(Collectors.toList()), headingTexts, options);
        }
    }

    public static void renderHtmlToc(HtmlWriter out, BasedSequence sourceText, List<Integer> headings, List<String> headingTexts, List<String> headingRefIds, TocOptions tocOptions) {
        int i;
        if (headings.size() > 0 && (sourceText.isNotNull() || !tocOptions.title.trim().isEmpty())) {
            if (sourceText.isNotNull()) {
                out.srcPos(sourceText);
            }
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)out.attr((CharSequence)"class", (CharSequence)tocOptions.divClass)).withAttr(TOC_CONTENT).tag((CharSequence)"div")).line()).indent();
            if (!tocOptions.title.trim().isEmpty()) {
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)out.tag((CharSequence)("h" + tocOptions.titleLevel))).text((CharSequence)tocOptions.title)).tag((CharSequence)("/h" + tocOptions.titleLevel))).line();
            }
        }
        int initLevel = -1;
        int lastLevel = -1;
        String listOpen = tocOptions.isNumbered ? "ol" : "ul";
        String listClose = "/" + listOpen;
        boolean[] openedItems = new boolean[7];
        boolean[] openedList = new boolean[7];
        int[] openedItemAppendCount = new int[7];
        for (i = 0; i < headings.size(); ++i) {
            int headerLevel;
            String headerText = headingTexts.get(i);
            int n = headerLevel = tocOptions.listType != TocOptions.ListType.HIERARCHY ? 1 : headings.get(i);
            if (initLevel == -1) {
                initLevel = headerLevel;
                lastLevel = headerLevel;
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)out.attr((CharSequence)"class", (CharSequence)tocOptions.listClass)).withAttr(TOC_LIST).line()).tag((CharSequence)listOpen)).indent()).line();
                openedList[0] = true;
            }
            if (lastLevel < headerLevel) {
                for (int lv = lastLevel; lv < headerLevel; ++lv) {
                    openedItems[lv + 1] = false;
                    openedList[lv + 1] = false;
                }
                if (!openedList[lastLevel]) {
                    ((HtmlWriter)((HtmlWriter)((HtmlWriter)out.withAttr().indent()).line()).tag((CharSequence)listOpen)).indent();
                    openedList[lastLevel] = true;
                }
            } else if (lastLevel == headerLevel) {
                if (openedItems[lastLevel]) {
                    if (openedList[lastLevel]) {
                        ((HtmlWriter)((HtmlWriter)out.unIndent()).tag((CharSequence)listClose)).line();
                    }
                    ((HtmlWriter)((HtmlWriter)out.lineIf(openedItemAppendCount[lastLevel] != out.offsetWithPending())).tag((CharSequence)"/li")).line();
                }
                openedItems[lastLevel] = false;
                openedList[lastLevel] = false;
            } else {
                for (int lv = lastLevel; lv >= headerLevel; --lv) {
                    if (openedItems[lv]) {
                        if (openedList[lv]) {
                            ((HtmlWriter)((HtmlWriter)((HtmlWriter)out.unIndent()).tag((CharSequence)listClose)).unIndent()).line();
                        }
                        ((HtmlWriter)((HtmlWriter)out.lineIf(openedItemAppendCount[lastLevel] != out.offsetWithPending())).tag((CharSequence)"/li")).line();
                    }
                    openedItems[lv] = false;
                    openedList[lv] = false;
                }
            }
            ((HtmlWriter)out.line()).tag((CharSequence)"li");
            openedItems[headerLevel] = true;
            String headerId = headingRefIds.get(i);
            if (headerId == null || headerId.isEmpty()) {
                out.raw((CharSequence)headerText);
            } else {
                ((HtmlWriter)out.attr((CharSequence)"href", (CharSequence)("#" + headerId))).withAttr().tag((CharSequence)"a");
                out.raw((CharSequence)headerText);
                out.tag((CharSequence)"/a");
            }
            lastLevel = headerLevel;
            openedItemAppendCount[headerLevel] = out.offsetWithPending();
        }
        for (i = lastLevel; i >= 1; --i) {
            if (!openedItems[i]) continue;
            if (openedList[i]) {
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)out.unIndent()).tag((CharSequence)listClose)).unIndent()).line();
            }
            ((HtmlWriter)((HtmlWriter)out.lineIf(openedItemAppendCount[lastLevel] != out.offsetWithPending())).tag((CharSequence)"/li")).line();
        }
        if (openedList[0]) {
            ((HtmlWriter)((HtmlWriter)out.unIndent()).tag((CharSequence)listClose)).line();
        }
        if (headings.size() > 0 && (sourceText.isNotNull() || !tocOptions.title.trim().isEmpty())) {
            ((HtmlWriter)((HtmlWriter)out.line()).unIndent()).tag((CharSequence)"/div");
        }
        out.line();
    }

    public static List<Heading> filteredHeadings(List<Heading> headings, TocOptions tocOptions) {
        ArrayList<Heading> filteredHeadings = new ArrayList<Heading>(headings.size());
        for (Heading header : headings) {
            if (!tocOptions.isLevelIncluded(header.getLevel()) || header.getParent() instanceof SimTocContent) continue;
            filteredHeadings.add(header);
        }
        return filteredHeadings;
    }

    public static Paired<List<Heading>, List<String>> htmlHeadingTexts(NodeRendererContext context, List<Heading> headings, TocOptions tocOptions) {
        ArrayList<String> headingContents = new ArrayList<String>(headings.size());
        boolean isReversed = tocOptions.listType == TocOptions.ListType.SORTED_REVERSED || tocOptions.listType == TocOptions.ListType.FLAT_REVERSED;
        boolean isSorted = tocOptions.listType == TocOptions.ListType.SORTED || tocOptions.listType == TocOptions.ListType.SORTED_REVERSED;
        boolean needText = isReversed || isSorted;
        HashMap<String, Heading> headingNodes = !needText ? null : new HashMap<String, Heading>(headings.size());
        HashMap<String, String> headingTexts = !needText || tocOptions.isTextOnly ? null : new HashMap<String, String>(headings.size());
        for (Heading heading : headings) {
            String headingContent;
            if (tocOptions.isTextOnly) {
                headingContent = TocUtils.getHeadingText(heading);
            } else {
                headingContent = TocUtils.getHeadingContent(context, heading);
                if (needText) {
                    headingTexts.put(headingContent, TocUtils.getHeadingText(heading));
                }
            }
            if (needText) {
                headingNodes.put(headingContent, heading);
            }
            headingContents.add(headingContent);
        }
        if (isSorted || isReversed) {
            if (tocOptions.isTextOnly) {
                if (isSorted) {
                    headingContents.sort((heading1, heading2) -> isReversed ? heading2.compareTo((String)heading1) : heading1.compareTo((String)heading2));
                } else {
                    Collections.reverse(headingContents);
                }
            } else if (isSorted) {
                headingContents.sort((heading1, heading2) -> {
                    String headingText1 = (String)headingTexts.get(heading1);
                    String headingText2 = (String)headingTexts.get(heading2);
                    return isReversed ? headingText2.compareTo(headingText1) : headingText1.compareTo(headingText2);
                });
            } else {
                Collections.reverse(headingContents);
            }
            headings = new ArrayList<Heading>();
            for (String headingContent : headingContents) {
                headings.add((Heading)headingNodes.get(headingContent));
            }
        }
        return Pair.of(headings, headingContents);
    }

    private static String getHeadingText(Heading header) {
        return Escaping.escapeHtml((CharSequence)new TextCollectingVisitor().collectAndGetText((Node)header), (boolean)false);
    }

    private static String getHeadingContent(NodeRendererContext context, Heading header) {
        NodeRendererContext subContext = context.getSubContext(false);
        subContext.doNotRenderLinks();
        subContext.renderChildren((Node)header);
        return subContext.getHtmlWriter().toString(-1, -1);
    }

    public static Pair<List<Heading>, List<String>> markdownHeaderTexts(List<Heading> headings, TocOptions tocOptions) {
        ArrayList<Object> headingContents = new ArrayList<Object>(headings.size());
        boolean isReversed = tocOptions.listType == TocOptions.ListType.SORTED_REVERSED || tocOptions.listType == TocOptions.ListType.FLAT_REVERSED;
        boolean isSorted = tocOptions.listType == TocOptions.ListType.SORTED || tocOptions.listType == TocOptions.ListType.SORTED_REVERSED;
        boolean needText = isReversed || isSorted;
        HashMap<Object, Heading> headingNodes = !needText ? null : new HashMap<Object, Heading>(headings.size());
        HashMap<Object, String> headingTexts = !needText || tocOptions.isTextOnly ? null : new HashMap<Object, String>(headings.size());
        for (Heading heading : headings) {
            String headingText = tocOptions.isTextOnly || needText ? new TextCollectingVisitor().collectAndGetText((Node)heading) : "";
            String headingContent = tocOptions.isTextOnly ? headingText : heading.getText().toString();
            String headerId = heading.getAnchorRefId();
            Object headerLink = headerId == null || headingContent.isEmpty() ? headingContent : "[" + headingContent + "](#" + headerId + ")";
            if (needText) {
                if (!tocOptions.isTextOnly) {
                    headingTexts.put(headerLink, headingText);
                }
                headingNodes.put(headerLink, heading);
            }
            headingContents.add(headerLink);
        }
        if (isSorted || isReversed) {
            if (tocOptions.isTextOnly) {
                if (isSorted) {
                    headingContents.sort((heading1, heading2) -> isReversed ? heading2.compareTo((String)heading1) : heading1.compareTo((String)heading2));
                } else {
                    Collections.reverse(headingContents);
                }
            } else if (isSorted) {
                headingContents.sort((heading1, heading2) -> {
                    String headingText1 = (String)headingTexts.get(heading1);
                    String headingText2 = (String)headingTexts.get(heading2);
                    return isReversed ? headingText2.compareTo(headingText1) : headingText1.compareTo(headingText2);
                });
            } else {
                Collections.reverse(headingContents);
            }
            headings = new ArrayList<Heading>();
            for (String string : headingContents) {
                headings.add((Heading)headingNodes.get(string));
            }
        }
        return Pair.of(headings, headingContents);
    }

    public static void renderMarkdownToc(MarkdownWriter out, List<Integer> headings, List<String> headingTexts, TocOptions tocOptions) {
        int i;
        int initLevel = -1;
        int lastLevel = -1;
        boolean[] openedItems = new boolean[7];
        boolean[] openedList = new boolean[7];
        int[] openedItemAppendCount = new int[7];
        for (i = 0; i < headings.size(); ++i) {
            int lv;
            int headerLevel;
            String headerText = headingTexts.get(i);
            int n = headerLevel = tocOptions.listType != TocOptions.ListType.HIERARCHY ? 1 : headings.get(i);
            if (initLevel == -1) {
                initLevel = headerLevel;
                lastLevel = headerLevel;
                out.line();
                openedList[0] = true;
            }
            if (lastLevel < headerLevel) {
                for (lv = lastLevel; lv < headerLevel; ++lv) {
                    openedItems[lv + 1] = false;
                    openedList[lv + 1] = false;
                }
                if (!openedList[lastLevel]) {
                    out.indent();
                    openedList[lastLevel] = true;
                }
            } else if (lastLevel == headerLevel) {
                if (openedItems[lastLevel]) {
                    if (openedList[lastLevel]) {
                        out.unIndent();
                    }
                    ((MarkdownWriter)out.lineIf(openedItemAppendCount[lastLevel] != out.offsetWithPending())).line();
                }
                openedItems[lastLevel] = false;
                openedList[lastLevel] = false;
            } else {
                for (lv = lastLevel; lv >= headerLevel; --lv) {
                    if (openedItems[lv]) {
                        if (openedList[lv]) {
                            out.unIndent();
                        }
                        ((MarkdownWriter)out.lineIf(openedItemAppendCount[lastLevel] != out.offsetWithPending())).line();
                    }
                    openedItems[lv] = false;
                    openedList[lv] = false;
                }
            }
            ((MarkdownWriter)out.line()).append((CharSequence)(tocOptions.isNumbered ? "1. " : "- "));
            openedItems[headerLevel] = true;
            out.append((CharSequence)headerText);
            lastLevel = headerLevel;
            openedItemAppendCount[headerLevel] = out.offsetWithPending();
        }
        for (i = lastLevel; i >= 1; --i) {
            if (!openedItems[i]) continue;
            if (openedList[i]) {
                out.unIndent();
            }
            ((MarkdownWriter)out.lineIf(openedItemAppendCount[lastLevel] != out.offsetWithPending())).line();
        }
        out.line();
    }
}

