/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.List;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExtendedBeanPropertyMeta;
import org.apache.juneau.MetaProvider;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlMetaProvider;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.apache.juneau.xml.annotation.XmlSchema;

public class XmlBeanPropertyMeta
extends ExtendedBeanPropertyMeta {
    public static final XmlBeanPropertyMeta DEFAULT = new XmlBeanPropertyMeta();
    private Namespace namespace = null;
    private XmlFormat xmlFormat = XmlFormat.DEFAULT;
    private String childName;
    private final XmlMetaProvider xmlMetaProvider;

    public XmlBeanPropertyMeta(BeanPropertyMeta bpm, XmlMetaProvider mp) {
        super(bpm);
        this.xmlMetaProvider = mp;
        for (Xml xml : bpm.getAnnotations(Xml.class)) {
            this.findXmlInfo(xml, mp);
        }
        if (this.namespace == null) {
            this.namespace = mp.getXmlClassMeta(bpm.getBeanMeta().getClassMeta()).getNamespace();
        }
    }

    private XmlBeanPropertyMeta() {
        super(null);
        this.xmlMetaProvider = null;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public XmlFormat getXmlFormat() {
        return this.xmlFormat;
    }

    public String getChildName() {
        return this.childName;
    }

    private void findXmlInfo(Xml xml, MetaProvider mp) {
        if (xml == null) {
            return;
        }
        BeanPropertyMeta bpm = this.getBeanPropertyMeta();
        ClassMeta<?> cmProperty = bpm.getClassMeta();
        ClassMeta<?> cmBean = bpm.getBeanMeta().getClassMeta();
        String name = bpm.getName();
        List<Xml> xmls = bpm.getAllAnnotations(Xml.class);
        List<XmlSchema> schemas = bpm.getAllAnnotations(XmlSchema.class);
        this.namespace = XmlUtils.findNamespace(xmls, schemas);
        if (this.xmlFormat == XmlFormat.DEFAULT) {
            this.xmlFormat = xml.format();
        }
        boolean isCollection = cmProperty.isCollectionOrArray();
        String cen = xml.childName();
        if (!cen.isEmpty() && !isCollection) {
            throw new BeanRuntimeException(cmProperty.getInnerClass(), "Annotation error on property ''{0}''.  @Xml.childName can only be specified on collections and arrays.", name);
        }
        if (this.xmlFormat == XmlFormat.COLLAPSED) {
            if (isCollection) {
                if (cen.isEmpty() && this.xmlMetaProvider != null) {
                    cen = this.xmlMetaProvider.getXmlClassMeta(cmProperty).getChildName();
                }
                if (cen == null || cen.isEmpty()) {
                    cen = cmProperty.getElementType().getDictionaryName();
                }
                if (cen == null || cen.isEmpty()) {
                    cen = name;
                }
            } else {
                throw new BeanRuntimeException(cmBean.getInnerClass(), "Annotation error on property ''{0}''.  @Xml.format=COLLAPSED can only be specified on collections and arrays.", name);
            }
            if (cen.isEmpty() && isCollection) {
                cen = cmProperty.getDictionaryName();
            }
        }
        if (!cen.isEmpty()) {
            this.childName = cen;
        }
    }
}

