/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class LongValue
extends Value<Long> {
    public static LongValue create() {
        return LongValue.of(0L);
    }

    public static LongValue of(Long value) {
        return new LongValue(value);
    }

    public LongValue(Long value) {
        super(value);
    }

    public LongValue add(Long x) {
        Long v = (Long)this.get();
        this.set((v == null ? 0L : v) + (x == null ? 0L : x));
        return this;
    }

    public Long addAndGet(Long x) {
        Long v = (Long)this.get();
        long result = (v == null ? 0L : v) + (x == null ? 0L : x);
        this.set(result);
        return result;
    }

    public LongValue decrement() {
        Long v = (Long)this.get();
        this.set((v == null ? 0L : v) - 1L);
        return this;
    }

    public Long decrementAndGet() {
        Long v = (Long)this.get();
        long result = (v == null ? 0L : v) - 1L;
        this.set(result);
        return result;
    }

    public long getAndIncrement() {
        Long v = (Long)this.get();
        this.set(v == null ? 1L : v + 1L);
        return v == null ? 0L : v;
    }

    public LongValue increment() {
        Long v = (Long)this.get();
        this.set((v == null ? 0L : v) + 1L);
        return this;
    }

    public Long incrementAndGet() {
        Long v = (Long)this.get();
        long result = (v == null ? 0L : v) + 1L;
        this.set(result);
        return result;
    }

    @Override
    public boolean is(Long value) {
        return Utils.eq((Long)this.get(), value);
    }

    public boolean isAny(Long ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        Long current = (Long)this.get();
        for (Long value : values) {
            if (!Utils.eq(current, value)) continue;
            return true;
        }
        return false;
    }
}

