/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.VoterSet;

public final class DynamicVoter {
    private final Uuid directoryId;
    private final int nodeId;
    private final String host;
    private final int port;

    public static DynamicVoter parse(String input) {
        Uuid directoryId;
        int port;
        int endColonIndex;
        String host;
        int nodeId;
        int atIndex = (input = input.trim()).indexOf("@");
        if (atIndex < 0) {
            throw new IllegalArgumentException("No @ found in dynamic voter string.");
        }
        if (atIndex == 0) {
            throw new IllegalArgumentException("Invalid @ at beginning of dynamic voter string.");
        }
        String idString = input.substring(0, atIndex);
        try {
            nodeId = Integer.parseInt(idString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse node id in dynamic voter string.", e);
        }
        if (nodeId < 0) {
            throw new IllegalArgumentException("Invalid negative node id " + nodeId + " in dynamic voter string.");
        }
        if ((input = input.substring(atIndex + 1)).isEmpty()) {
            throw new IllegalArgumentException("No hostname found after node id.");
        }
        if (input.startsWith("[")) {
            int endBracketIndex = input.indexOf("]");
            if (endBracketIndex < 0) {
                throw new IllegalArgumentException("Hostname began with left bracket, but no right bracket was found.");
            }
            host = input.substring(1, endBracketIndex);
            input = input.substring(endBracketIndex + 1);
        } else {
            endColonIndex = input.indexOf(":");
            if (endColonIndex < 0) {
                throw new IllegalArgumentException("No colon following hostname could be found.");
            }
            host = input.substring(0, endColonIndex);
            input = input.substring(endColonIndex);
        }
        if (!input.startsWith(":")) {
            throw new IllegalArgumentException("Port section must start with a colon.");
        }
        endColonIndex = (input = input.substring(1)).indexOf(":");
        if (endColonIndex < 0) {
            throw new IllegalArgumentException("No colon following port could be found.");
        }
        String portString = input.substring(0, endColonIndex);
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse port in dynamic voter string.", e);
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port " + port + " in dynamic voter string.");
        }
        String directoryIdString = input.substring(endColonIndex + 1);
        try {
            directoryId = Uuid.fromString((String)directoryIdString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to parse directory ID in dynamic voter string.", e);
        }
        return new DynamicVoter(directoryId, nodeId, host, port);
    }

    public DynamicVoter(Uuid directoryId, int nodeId, String host, int port) {
        this.directoryId = directoryId;
        this.nodeId = nodeId;
        this.host = host;
        this.port = port;
    }

    public Uuid directoryId() {
        return this.directoryId;
    }

    public int nodeId() {
        return this.nodeId;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public VoterSet.VoterNode toVoterNode(String controllerListenerName) {
        ReplicaKey voterKey = ReplicaKey.of(this.nodeId, this.directoryId);
        Endpoints listeners = Endpoints.fromInetSocketAddresses(Collections.singletonMap(ListenerName.normalised((String)controllerListenerName), new InetSocketAddress(this.host, this.port)));
        SupportedVersionRange supportedKRaftVersion = new SupportedVersionRange(0, 1);
        return VoterSet.VoterNode.of(voterKey, listeners, supportedKRaftVersion);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(DynamicVoter.class)) {
            return false;
        }
        DynamicVoter other = (DynamicVoter)o;
        return this.directoryId.equals((Object)other.directoryId) && this.nodeId == other.nodeId && this.host.equals(other.host) && this.port == other.port;
    }

    public int hashCode() {
        return Objects.hash(this.directoryId, this.nodeId, this.host, this.port);
    }

    public String toString() {
        if (this.host.contains(":")) {
            return this.nodeId + "@[" + this.host + "]:" + this.port + ":" + String.valueOf(this.directoryId);
        }
        return this.nodeId + "@" + this.host + ":" + this.port + ":" + String.valueOf(this.directoryId);
    }
}

