/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.assignor.AssignorHelpers;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;

public class UniformHeterogeneousAssignmentBuilder {
    private static final int MAX_ITERATION_COUNT = 16;
    private final GroupSpec groupSpec;
    private final SubscribedTopicDescriber subscribedTopicDescriber;
    private final Set<Uuid> subscribedTopicIds;
    private final List<String> memberIds;
    private final Map<String, Integer> memberIndices;
    private final Map<Uuid, List<Integer>> topicSubscribers;
    private final Map<String, MemberAssignment> targetAssignment;
    private final int[] memberTargetAssignmentSizes;
    private final Comparator<Uuid> topicComparator;
    private final Comparator<Integer> memberComparator;
    private final Map<Uuid, int[]> targetAssignmentPartitionOwners;

    public UniformHeterogeneousAssignmentBuilder(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) {
        int memberIndex;
        this.groupSpec = groupSpec;
        this.subscribedTopicDescriber = subscribedTopicDescriber;
        this.subscribedTopicIds = new HashSet<Uuid>();
        this.memberIds = new ArrayList<String>(groupSpec.memberIds());
        this.memberIndices = new HashMap<String, Integer>();
        for (memberIndex = 0; memberIndex < this.memberIds.size(); ++memberIndex) {
            this.memberIndices.put(this.memberIds.get(memberIndex), memberIndex);
        }
        this.topicSubscribers = new HashMap<Uuid, List<Integer>>();
        this.targetAssignment = new HashMap<String, MemberAssignment>();
        this.memberTargetAssignmentSizes = new int[this.memberIds.size()];
        for (memberIndex = 0; memberIndex < this.memberIds.size(); ++memberIndex) {
            String memberId = this.memberIds.get(memberIndex);
            for (Uuid topicId : groupSpec.memberSubscription(memberId).subscribedTopicIds()) {
                int numPartitions = subscribedTopicDescriber.numPartitions(topicId);
                if (numPartitions == -1) {
                    throw new PartitionAssignorException("Members are subscribed to topic " + String.valueOf(topicId) + " which doesn't exist in the topic metadata.");
                }
                this.subscribedTopicIds.add(topicId);
                this.topicSubscribers.computeIfAbsent(topicId, k -> new ArrayList()).add(memberIndex);
            }
        }
        this.topicComparator = (topic1Id, topic2Id) -> {
            int topic1PartitionCount = subscribedTopicDescriber.numPartitions(topic1Id);
            int topic2PartitionCount = subscribedTopicDescriber.numPartitions(topic2Id);
            int topic1SubscriberCount = this.topicSubscribers.get(topic1Id).size();
            int topic2SubscriberCount = this.topicSubscribers.get(topic2Id).size();
            int order = Double.compare((double)topic2PartitionCount / (double)topic2SubscriberCount, (double)topic1PartitionCount / (double)topic1SubscriberCount);
            if (order == 0) {
                order = Integer.compare(topic1SubscriberCount, topic2SubscriberCount);
            }
            if (order == 0) {
                order = topic1Id.compareTo(topic2Id);
            }
            return order;
        };
        this.memberComparator = (memberIndex1, memberIndex2) -> {
            int order = Integer.compare(this.memberTargetAssignmentSizes[memberIndex1], this.memberTargetAssignmentSizes[memberIndex2]);
            if (order == 0) {
                order = memberIndex1.compareTo((Integer)memberIndex2);
            }
            return order;
        };
        this.targetAssignmentPartitionOwners = new HashMap<Uuid, int[]>((int)((float)this.subscribedTopicIds.size() / 0.75f + 1.0f));
        for (Uuid topicId : this.subscribedTopicIds) {
            int numPartitions = subscribedTopicDescriber.numPartitions(topicId);
            int[] partitionOwners = new int[numPartitions];
            Arrays.fill(partitionOwners, -1);
            this.targetAssignmentPartitionOwners.put(topicId, partitionOwners);
        }
    }

    public GroupAssignment build() {
        if (this.subscribedTopicIds.isEmpty()) {
            return new GroupAssignment(Collections.emptyMap());
        }
        this.maybeRevokePartitions();
        Map<Uuid, List<Integer>> unassignedPartitions = this.computeUnassignedPartitions();
        this.assignRemainingPartitions(unassignedPartitions);
        this.balance();
        return new GroupAssignment(this.targetAssignment);
    }

    private List<Uuid> sortTopicIds(Collection<Uuid> topicIds) {
        ArrayList<Uuid> sortedTopicIds = new ArrayList<Uuid>(topicIds);
        sortedTopicIds.sort(this.topicComparator);
        return sortedTopicIds;
    }

    private void maybeRevokePartitions() {
        for (String memberId : this.groupSpec.memberIds()) {
            int memberIndex = this.memberIndices.get(memberId);
            Map<Uuid, Set<Integer>> oldAssignment = this.groupSpec.memberAssignment(memberId).partitions();
            Map<Uuid, Set<Integer>> newAssignment = null;
            if (!AssignorHelpers.isImmutableMap(oldAssignment)) {
                throw new IllegalStateException("The assignor expect an immutable map.");
            }
            for (Map.Entry topicPartitions : oldAssignment.entrySet()) {
                Uuid topicId = (Uuid)topicPartitions.getKey();
                Set partitions = (Set)topicPartitions.getValue();
                if (this.groupSpec.memberSubscription(memberId).subscribedTopicIds().contains(topicId)) {
                    int n = memberIndex;
                    this.memberTargetAssignmentSizes[n] = this.memberTargetAssignmentSizes[n] + partitions.size();
                    Iterator iterator = partitions.iterator();
                    while (iterator.hasNext()) {
                        int partition = (Integer)iterator.next();
                        this.targetAssignmentPartitionOwners.get((Object)topicId)[partition] = memberIndex;
                    }
                    continue;
                }
                if (newAssignment == null) {
                    newAssignment = AssignorHelpers.deepCopyAssignment(oldAssignment);
                }
                newAssignment.remove(topicId);
            }
            if (newAssignment == null) {
                newAssignment = oldAssignment;
            }
            this.targetAssignment.put(memberId, new MemberAssignmentImpl(newAssignment));
        }
    }

    private void assignRemainingPartitions(Map<Uuid, List<Integer>> partitions) {
        List<Uuid> sortedTopicIds = this.sortTopicIds(partitions.keySet());
        MemberAssignmentBalancer memberAssignmentBalancer = new MemberAssignmentBalancer();
        for (Uuid topicId : sortedTopicIds) {
            memberAssignmentBalancer.initialize(this.topicSubscribers.get(topicId));
            for (int partition : partitions.get(topicId)) {
                int leastLoadedMemberIndex = memberAssignmentBalancer.nextLeastLoadedMember();
                this.assignPartition(topicId, partition, leastLoadedMemberIndex);
            }
        }
    }

    private boolean canTopicParticipateInReassignment(Uuid topicId) {
        return this.topicSubscribers.get(topicId).size() >= 2;
    }

    private void balance() {
        HashSet<Uuid> topicIds = new HashSet<Uuid>(this.subscribedTopicIds);
        for (Uuid topicId : this.subscribedTopicIds) {
            if (this.canTopicParticipateInReassignment(topicId)) continue;
            topicIds.remove(topicId);
        }
        if (!topicIds.isEmpty()) {
            this.balanceTopics(topicIds);
        }
    }

    private void balanceTopics(Collection<Uuid> topicIds) {
        List<Uuid> sortedTopicIds = this.sortTopicIds(topicIds);
        int lastRebalanceTopicIndex = -1;
        MemberAssignmentBalancer memberAssignmentBalancer = new MemberAssignmentBalancer();
        ArrayList<Integer> partitions = new ArrayList<Integer>();
        HashMap<Integer, Integer> startPartitionIndices = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> endPartitionIndices = new HashMap<Integer, Integer>();
        for (int i = 0; i < 16; ++i) {
            for (int topicIndex = 0; topicIndex < sortedTopicIds.size(); ++topicIndex) {
                if (topicIndex == lastRebalanceTopicIndex) {
                    return;
                }
                Uuid topicId = sortedTopicIds.get(topicIndex);
                int reassignedPartitionCount = this.balanceTopic(topicId, memberAssignmentBalancer, partitions, startPartitionIndices, endPartitionIndices);
                if (reassignedPartitionCount <= 0 && lastRebalanceTopicIndex != -1) continue;
                lastRebalanceTopicIndex = topicIndex;
            }
        }
    }

    private int balanceTopic(Uuid topicId, MemberAssignmentBalancer memberAssignmentBalancer, List<Integer> partitions, Map<Integer, Integer> startPartitionIndices, Map<Integer, Integer> endPartitionIndices) {
        int partition2;
        int reassignedPartitionCount = 0;
        int numPartitions = this.subscribedTopicDescriber.numPartitions(topicId);
        int[] partitionOwners = this.targetAssignmentPartitionOwners.get(topicId);
        int imbalance = memberAssignmentBalancer.initialize(this.topicSubscribers.get(topicId));
        if (imbalance <= 1) {
            return reassignedPartitionCount;
        }
        partitions.clear();
        for (int partition3 = 0; partition3 < numPartitions; ++partition3) {
            partitions.add(partition3);
        }
        partitions.sort(Comparator.comparingInt(partition -> partitionOwners[partition]).thenComparingInt(partition -> partition));
        startPartitionIndices.clear();
        endPartitionIndices.clear();
        for (int i = 0; i < numPartitions; ++i) {
            partition2 = partitions.get(i);
            int ownerIndex = partitionOwners[partition2];
            startPartitionIndices.putIfAbsent(ownerIndex, i);
            endPartitionIndices.put(ownerIndex, i + 1);
        }
        while (!memberAssignmentBalancer.isBalanced()) {
            int mostLoadedMemberIndex = -1;
            while (!((mostLoadedMemberIndex = memberAssignmentBalancer.nextMostLoadedMember()) == -1 || endPartitionIndices.containsKey(mostLoadedMemberIndex) && endPartitionIndices.get(mostLoadedMemberIndex) - startPartitionIndices.get(mostLoadedMemberIndex) > 0)) {
                memberAssignmentBalancer.excludeMostLoadedMember();
            }
            if (mostLoadedMemberIndex == -1) break;
            partition2 = partitions.get(endPartitionIndices.get(mostLoadedMemberIndex) - 1);
            endPartitionIndices.put(mostLoadedMemberIndex, endPartitionIndices.get(mostLoadedMemberIndex) - 1);
            int leastLoadedMemberIndex = memberAssignmentBalancer.nextLeastLoadedMember();
            if (memberAssignmentBalancer.isBalanced()) break;
            this.assignPartition(topicId, partition2, leastLoadedMemberIndex);
            ++reassignedPartitionCount;
        }
        return reassignedPartitionCount;
    }

    private Map<Uuid, List<Integer>> computeUnassignedPartitions() {
        HashMap<Uuid, List<Integer>> unassignedPartitions = new HashMap<Uuid, List<Integer>>();
        for (Uuid topicId : this.subscribedTopicIds) {
            ArrayList<Integer> topicUnassignedPartitions = new ArrayList<Integer>();
            int numPartitions = this.subscribedTopicDescriber.numPartitions(topicId);
            for (int partition = 0; partition < numPartitions; ++partition) {
                if (this.targetAssignmentPartitionOwners.get(topicId)[partition] != -1) continue;
                topicUnassignedPartitions.add(partition);
            }
            if (topicUnassignedPartitions.isEmpty()) continue;
            unassignedPartitions.put(topicId, topicUnassignedPartitions);
        }
        return unassignedPartitions;
    }

    private void assignPartition(Uuid topicId, int partition, int memberIndex) {
        int oldMemberIndex = this.targetAssignmentPartitionOwners.get(topicId)[partition];
        if (oldMemberIndex != -1) {
            this.removePartitionFromTargetAssignment(topicId, partition, oldMemberIndex);
        }
        this.addPartitionToTargetAssignment(topicId, partition, memberIndex);
    }

    private void addPartitionToTargetAssignment(Uuid topicId, int partition, int memberIndex) {
        String memberId = this.memberIds.get(memberIndex);
        Map<Uuid, Set<Integer>> assignment = this.targetAssignment.get(memberId).partitions();
        if (AssignorHelpers.isImmutableMap(assignment)) {
            assignment = AssignorHelpers.deepCopyAssignment(assignment);
            this.targetAssignment.put(memberId, new MemberAssignmentImpl(assignment));
        }
        assignment.computeIfAbsent(topicId, __ -> {
            int numPartitions = this.subscribedTopicDescriber.numPartitions(topicId);
            int numSubscribers = this.topicSubscribers.get(topicId).size();
            int estimatedPartitionsPerSubscriber = (numPartitions + numSubscribers - 1) / numSubscribers;
            return new HashSet((int)((float)estimatedPartitionsPerSubscriber / 0.75f + 1.0f));
        }).add(partition);
        this.targetAssignmentPartitionOwners.get((Object)topicId)[partition] = memberIndex;
        int n = memberIndex;
        this.memberTargetAssignmentSizes[n] = this.memberTargetAssignmentSizes[n] + 1;
    }

    private void removePartitionFromTargetAssignment(Uuid topicId, int partition, int memberIndex) {
        Set<Integer> partitionsSet;
        String memberId = this.memberIds.get(memberIndex);
        Map<Uuid, Set<Integer>> assignment = this.targetAssignment.get(memberId).partitions();
        if (AssignorHelpers.isImmutableMap(assignment)) {
            assignment = AssignorHelpers.deepCopyAssignment(assignment);
            this.targetAssignment.put(memberId, new MemberAssignmentImpl(assignment));
        }
        if ((partitionsSet = assignment.get(topicId)) != null) {
            partitionsSet.remove(partition);
            if (partitionsSet.isEmpty()) {
                assignment.remove(topicId);
            }
        }
        this.targetAssignmentPartitionOwners.get((Object)topicId)[partition] = -1;
        int n = memberIndex;
        this.memberTargetAssignmentSizes[n] = this.memberTargetAssignmentSizes[n] - 1;
    }

    private final class MemberAssignmentBalancer {
        private final int[] memberTargetAssignmentSizes;
        private final List<Integer> sortedMembers;
        private int leastLoadedRangeEnd = 0;
        private int leastLoadedRangePartitionCount = -1;
        private int nextLeastLoadedMember = 0;
        private int mostLoadedRangeStart = 0;
        private int mostLoadedRangeEnd = 0;
        private int mostLoadedRangePartitionCount = 1;
        private int nextMostLoadedMember = -1;

        public MemberAssignmentBalancer() {
            this.memberTargetAssignmentSizes = UniformHeterogeneousAssignmentBuilder.this.memberTargetAssignmentSizes;
            this.sortedMembers = new ArrayList<Integer>(this.memberTargetAssignmentSizes.length);
        }

        public int initialize(List<Integer> members) {
            if (members.isEmpty()) {
                throw new IllegalArgumentException("Cannot balance an empty subscriber list.");
            }
            this.sortedMembers.clear();
            this.sortedMembers.addAll(members);
            this.sortedMembers.sort(UniformHeterogeneousAssignmentBuilder.this.memberComparator);
            this.leastLoadedRangeEnd = 0;
            this.leastLoadedRangePartitionCount = this.memberTargetAssignmentSizes[this.sortedMembers.get(0)] - 1;
            this.nextLeastLoadedMember = 0;
            this.mostLoadedRangeStart = this.sortedMembers.size();
            this.mostLoadedRangeEnd = this.sortedMembers.size();
            this.mostLoadedRangePartitionCount = this.memberTargetAssignmentSizes[this.sortedMembers.get(this.sortedMembers.size() - 1)] + 1;
            this.nextMostLoadedMember = this.sortedMembers.size() - 1;
            return this.memberTargetAssignmentSizes[this.sortedMembers.get(this.sortedMembers.size() - 1)] - this.memberTargetAssignmentSizes[this.sortedMembers.get(0)];
        }

        public int nextLeastLoadedMember() {
            if (this.nextLeastLoadedMember >= this.leastLoadedRangeEnd) {
                ++this.leastLoadedRangePartitionCount;
                while (this.leastLoadedRangeEnd < this.sortedMembers.size() && this.memberTargetAssignmentSizes[this.sortedMembers.get(this.leastLoadedRangeEnd)] == this.leastLoadedRangePartitionCount) {
                    ++this.leastLoadedRangeEnd;
                }
                this.nextLeastLoadedMember = 0;
            }
            int leastLoadedMemberIndex = this.sortedMembers.get(this.nextLeastLoadedMember);
            ++this.nextLeastLoadedMember;
            return leastLoadedMemberIndex;
        }

        public int nextMostLoadedMember() {
            if (this.nextMostLoadedMember < this.mostLoadedRangeStart) {
                this.mostLoadedRangePartitionCount = this.mostLoadedRangeEnd <= this.mostLoadedRangeStart && this.mostLoadedRangeStart > 0 ? this.memberTargetAssignmentSizes[this.sortedMembers.get(this.mostLoadedRangeStart - 1)] : --this.mostLoadedRangePartitionCount;
                while (this.mostLoadedRangeStart > 0 && this.memberTargetAssignmentSizes[this.sortedMembers.get(this.mostLoadedRangeStart - 1)] == this.mostLoadedRangePartitionCount) {
                    --this.mostLoadedRangeStart;
                }
                this.nextMostLoadedMember = this.mostLoadedRangeEnd - 1;
            }
            if (this.nextMostLoadedMember < 0) {
                return -1;
            }
            int mostLoadedMemberIndex = this.sortedMembers.get(this.nextMostLoadedMember);
            --this.nextMostLoadedMember;
            return mostLoadedMemberIndex;
        }

        public void excludeMostLoadedMember() {
            int mostLoadedMemberIndex = this.sortedMembers.get(this.nextMostLoadedMember + 1);
            this.sortedMembers.set(this.nextMostLoadedMember + 1, this.sortedMembers.get(this.mostLoadedRangeEnd - 1));
            this.sortedMembers.set(this.mostLoadedRangeEnd - 1, mostLoadedMemberIndex);
            --this.mostLoadedRangeEnd;
        }

        public boolean isBalanced() {
            return this.mostLoadedRangePartitionCount - this.leastLoadedRangePartitionCount <= 1;
        }
    }
}

