/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.properties;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;

public final class MetaProperties {
    static final String VERSION_PROP = "version";
    static final String CLUSTER_ID_PROP = "cluster.id";
    static final String BROKER_ID_PROP = "broker.id";
    static final String NODE_ID_PROP = "node.id";
    static final String DIRECTORY_ID_PROP = "directory.id";
    private final MetaPropertiesVersion version;
    private final Optional<String> clusterId;
    private final OptionalInt nodeId;
    private final Optional<Uuid> directoryId;

    private MetaProperties(MetaPropertiesVersion version, Optional<String> clusterId, OptionalInt nodeId, Optional<Uuid> directoryId) {
        this.version = version;
        this.clusterId = clusterId;
        this.nodeId = nodeId;
        this.directoryId = directoryId;
    }

    public MetaPropertiesVersion version() {
        return this.version;
    }

    public Optional<String> clusterId() {
        return this.clusterId;
    }

    public OptionalInt nodeId() {
        return this.nodeId;
    }

    public Optional<Uuid> directoryId() {
        return this.directoryId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.clusterId, this.nodeId, this.directoryId});
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(MetaProperties.class)) {
            return false;
        }
        MetaProperties other = (MetaProperties)o;
        return this.version.equals((Object)other.version) && this.clusterId.equals(other.clusterId) && this.nodeId.equals(other.nodeId) && this.directoryId.equals(other.directoryId);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("MetaProperties");
        bld.append("(version=").append(this.version.number());
        if (this.clusterId.isPresent()) {
            bld.append(", clusterId=").append(this.clusterId.get());
        }
        if (this.nodeId.isPresent()) {
            bld.append(", nodeId=").append(this.nodeId.getAsInt());
        }
        if (this.directoryId.isPresent()) {
            bld.append(", directoryId=").append(this.directoryId.get());
        }
        bld.append(")");
        return bld.toString();
    }

    public Properties toProperties() {
        Properties props = new Properties();
        props.setProperty(VERSION_PROP, this.version.numberString());
        if (this.clusterId.isPresent()) {
            props.setProperty(CLUSTER_ID_PROP, this.clusterId.get());
        }
        if (this.version.hasBrokerId()) {
            if (this.nodeId.isPresent()) {
                props.setProperty(BROKER_ID_PROP, "" + this.nodeId.getAsInt());
            }
        } else {
            props.setProperty(NODE_ID_PROP, "" + this.nodeId.getAsInt());
        }
        if (this.directoryId.isPresent()) {
            props.setProperty(DIRECTORY_ID_PROP, this.directoryId.get().toString());
        }
        return props;
    }

    public static class Builder {
        private MetaPropertiesVersion version = MetaPropertiesVersion.V0;
        private Optional<String> clusterId = Optional.empty();
        private OptionalInt nodeId = OptionalInt.empty();
        private Optional<Uuid> directoryId = Optional.empty();

        public Builder() {
        }

        public Builder(Optional<MetaProperties> metaProps) {
            if (metaProps.isPresent()) {
                this.version = metaProps.get().version();
                this.clusterId = metaProps.get().clusterId();
                this.nodeId = metaProps.get().nodeId();
                this.directoryId = metaProps.get().directoryId();
            }
        }

        public Builder(MetaProperties metaProps) {
            this(Optional.of(metaProps));
        }

        public Builder(Properties props) {
            this.version = MetaPropertiesVersion.fromNumberString(props.getProperty(MetaProperties.VERSION_PROP, MetaPropertiesVersion.V0.numberString()));
            if (this.version.hasBrokerId()) {
                if (props.containsKey(MetaProperties.BROKER_ID_PROP)) {
                    this.nodeId = OptionalInt.of(PropertiesUtils.loadRequiredIntProp(props, MetaProperties.BROKER_ID_PROP));
                }
            } else {
                this.nodeId = OptionalInt.of(PropertiesUtils.loadRequiredIntProp(props, MetaProperties.NODE_ID_PROP));
            }
            this.clusterId = Optional.ofNullable(props.getProperty(MetaProperties.CLUSTER_ID_PROP));
            if (props.containsKey(MetaProperties.DIRECTORY_ID_PROP)) {
                try {
                    this.directoryId = Optional.of(Uuid.fromString((String)props.getProperty(MetaProperties.DIRECTORY_ID_PROP)));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to read directory.id as a Uuid: " + e.getMessage(), e);
                }
            } else {
                this.directoryId = Optional.empty();
            }
        }

        public MetaPropertiesVersion version() {
            return this.version;
        }

        public Builder setVersion(MetaPropertiesVersion version) {
            this.version = version;
            return this;
        }

        public Optional<String> clusterId() {
            return this.clusterId;
        }

        public Builder setClusterId(String clusterId) {
            return this.setClusterId(Optional.of(clusterId));
        }

        public Builder setClusterId(Optional<String> clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public OptionalInt nodeId() {
            return this.nodeId;
        }

        public Builder setNodeId(OptionalInt nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setNodeId(int nodeId) {
            return this.setNodeId(OptionalInt.of(nodeId));
        }

        public Optional<Uuid> directoryId() {
            return this.directoryId;
        }

        public Builder setDirectoryId(Optional<Uuid> directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public Builder setDirectoryId(Uuid directoryId) {
            return this.setDirectoryId(Optional.of(directoryId));
        }

        public MetaProperties build() {
            if (!this.version.equals((Object)MetaPropertiesVersion.V0)) {
                if (this.clusterId.isEmpty()) {
                    throw new RuntimeException("cluster.id was not found.");
                }
                if (this.nodeId.isEmpty()) {
                    throw new RuntimeException("node.id was not found.");
                }
            }
            return new MetaProperties(this.version, this.clusterId, this.nodeId, this.directoryId);
        }
    }
}

