/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.common.runtime.HdrHistogram;

public final class KafkaMetricHistogram
implements CompoundStat {
    public static final int NUM_SIG_FIGS = 3;
    public static final long MAX_LATENCY_MS = Duration.ofMinutes(1L).toMillis();
    private static final String MAX_NAME = "max";
    private static final Map<Double, String> PERCENTILE_NAMES = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)50.0, (Object)"p50"), Utils.mkEntry((Object)95.0, (Object)"p95"), Utils.mkEntry((Object)99.0, (Object)"p99"), Utils.mkEntry((Object)99.9, (Object)"p999")});
    private final Function<String, MetricName> metricNameFactory;
    private final HdrHistogram hdrHistogram;

    public static KafkaMetricHistogram newLatencyHistogram(Function<String, MetricName> metricNameFactory) {
        return new KafkaMetricHistogram(metricNameFactory, MAX_LATENCY_MS, 3);
    }

    private KafkaMetricHistogram(Function<String, MetricName> metricNameFactory, long highestTrackableValue, int numberOfSignificantValueDigits) {
        this.metricNameFactory = metricNameFactory;
        this.hdrHistogram = new HdrHistogram(highestTrackableValue, numberOfSignificantValueDigits);
    }

    public List<CompoundStat.NamedMeasurable> stats() {
        ArrayList<CompoundStat.NamedMeasurable> stats = new ArrayList<CompoundStat.NamedMeasurable>();
        stats.add(new CompoundStat.NamedMeasurable(this.metricNameFactory.apply(MAX_NAME), (config, now) -> this.hdrHistogram.max(now)));
        PERCENTILE_NAMES.entrySet().stream().map(e -> new CompoundStat.NamedMeasurable(this.metricNameFactory.apply((String)e.getValue()), (config, now) -> this.hdrHistogram.measurePercentile(now, (Double)e.getKey()))).forEachOrdered(stats::add);
        return stats;
    }

    public void record(MetricConfig config, double value, long timeMs) {
        this.hdrHistogram.record((long)value);
    }
}

