/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.io.PrintStream;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaShareConsumer;
import org.apache.kafka.clients.consumer.ShareConsumer;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.tools.consumer.ConsoleShareConsumerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleShareConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleShareConsumer.class);
    private static final CountDownLatch SHUTDOWN_LATCH = new CountDownLatch(1);
    static int messageCount = 0;

    public static void main(String[] args) throws Exception {
        ConsoleShareConsumerOptions opts = new ConsoleShareConsumerOptions(args);
        try {
            ConsoleShareConsumer.run(opts);
        }
        catch (AuthenticationException ae) {
            LOG.error("Authentication failed: terminating consumer process", (Throwable)ae);
            Exit.exit((int)1);
        }
        catch (Throwable t) {
            LOG.error("Unknown error when running consumer: ", t);
            Exit.exit((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(ConsoleShareConsumerOptions opts) {
        messageCount = 0;
        long timeoutMs = opts.timeoutMs() >= 0 ? (long)opts.timeoutMs() : Long.MAX_VALUE;
        KafkaShareConsumer consumer = new KafkaShareConsumer(opts.consumerProps(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        ConsumerWrapper consumerWrapper = new ConsumerWrapper(opts.topicArg(), (ShareConsumer<byte[], byte[]>)consumer, timeoutMs);
        ConsoleShareConsumer.addShutdownHook(consumerWrapper);
        try {
            ConsoleShareConsumer.process(opts.maxMessages(), opts.formatter(), consumerWrapper, System.out, opts.rejectMessageOnError(), opts.acknowledgeType());
        }
        finally {
            consumerWrapper.cleanup();
            opts.formatter().close();
            ConsoleShareConsumer.reportRecordCount();
            SHUTDOWN_LATCH.countDown();
        }
    }

    private static void addShutdownHook(ConsumerWrapper consumer) {
        Exit.addShutdownHook((String)"consumer-shutdown-hook", () -> {
            try {
                consumer.wakeup();
                SHUTDOWN_LATCH.await();
            }
            catch (Throwable t) {
                LOG.error("Exception while running shutdown hook: ", t);
            }
        });
    }

    static void process(int maxMessages, MessageFormatter formatter, ConsumerWrapper consumer, PrintStream output, boolean rejectMessageOnError, AcknowledgeType acknowledgeType) {
        while (messageCount < maxMessages || maxMessages == -1) {
            ConsumerRecord<byte[], byte[]> msg;
            try {
                msg = consumer.receive();
            }
            catch (WakeupException we) {
                LOG.trace("Caught WakeupException because consumer is shutdown, ignore and terminate.");
                return;
            }
            catch (Throwable t) {
                LOG.error("Error processing message, terminating consumer process: ", t);
                return;
            }
            ++messageCount;
            try {
                formatter.writeTo(new ConsumerRecord(msg.topic(), msg.partition(), msg.offset(), msg.timestamp(), msg.timestampType(), 0, 0, (Object)((byte[])msg.key()), (Object)((byte[])msg.value()), msg.headers(), Optional.empty()), output);
                consumer.acknowledge(msg, acknowledgeType);
            }
            catch (Throwable t) {
                if (rejectMessageOnError) {
                    LOG.error("Error processing message, rejecting this message: ", t);
                    consumer.acknowledge(msg, AcknowledgeType.REJECT);
                }
                throw t;
            }
            if (!ConsoleShareConsumer.checkErr(output)) continue;
            return;
        }
    }

    private static void reportRecordCount() {
        System.err.println("Processed a total of " + messageCount + " messages");
    }

    private static boolean checkErr(PrintStream output) {
        boolean gotError = output.checkError();
        if (gotError) {
            System.err.println("Unable to write to standard out, closing consumer.");
        }
        return gotError;
    }

    public static class ConsumerWrapper {
        final String topic;
        final ShareConsumer<byte[], byte[]> consumer;
        final long timeoutMs;
        final Time time = Time.SYSTEM;
        Iterator<ConsumerRecord<byte[], byte[]>> recordIter = Collections.emptyIterator();

        public ConsumerWrapper(String topic, ShareConsumer<byte[], byte[]> consumer, long timeoutMs) {
            this.topic = topic;
            this.consumer = consumer;
            this.timeoutMs = timeoutMs;
            consumer.subscribe(Collections.singletonList(topic));
        }

        ConsumerRecord<byte[], byte[]> receive() {
            long startTimeMs = this.time.milliseconds();
            while (!this.recordIter.hasNext()) {
                this.recordIter = this.consumer.poll(Duration.ofMillis(this.timeoutMs)).iterator();
                if (this.recordIter.hasNext() || this.time.milliseconds() - startTimeMs <= this.timeoutMs) continue;
                throw new TimeoutException();
            }
            return this.recordIter.next();
        }

        void acknowledge(ConsumerRecord<byte[], byte[]> record, AcknowledgeType acknowledgeType) {
            this.consumer.acknowledge(record, acknowledgeType);
        }

        void wakeup() {
            this.consumer.wakeup();
        }

        void cleanup() {
            this.consumer.close();
        }
    }
}

