/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.kafka.common.errors;

/**
 * Indicates that the error is fatal to the producer, and the application
 * needs to restart the producer after handling the error. Depending on the application,
 * different recovery strategies (e.g., re-balancing task, restoring from checkpoints) may be employed.
 */
public abstract class ApplicationRecoverableException extends ApiException {
    private static final long serialVersionUID = 1L;

    public ApplicationRecoverableException(String message, Throwable cause) {
        super(message, cause);
    }

    public ApplicationRecoverableException(String message) {
        super(message);
    }

    public ApplicationRecoverableException(Throwable cause) {
        super(cause);
    }

    public ApplicationRecoverableException() {
        super();
    }

}
