/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.OnePassDataIndexer;
import opennlp.tools.ml.model.OnePassRealValueDataIndexer;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.ext.ExtensionLoader;

public class DataIndexerFactory {
    public static DataIndexer getDataIndexer(TrainingParameters parameters, Map<String, String> reportMap) {
        String indexerParam = parameters.getStringParameter("DataIndexer", "TwoPass");
        if (reportMap == null) {
            reportMap = new HashMap<String, String>();
        }
        DataIndexer indexer = switch (indexerParam) {
            case "OnePass" -> new OnePassDataIndexer();
            case "TwoPass" -> new TwoPassDataIndexer();
            case "OnePassRealValue" -> new OnePassRealValueDataIndexer();
            default -> ExtensionLoader.instantiateExtension(DataIndexer.class, indexerParam);
        };
        indexer.init(parameters, reportMap);
        return indexer;
    }
}

