/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.index.Term;
import org.apache.lucene.monitor.CustomQueryHandler;
import org.apache.lucene.monitor.QueryTree;
import org.apache.lucene.monitor.TermWeightor;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;

class QueryAnalyzer {
    private final BiFunction<Query, TermWeightor, QueryTree> unknownQueryMapper;

    QueryAnalyzer(List<CustomQueryHandler> queryTreeBuilders) {
        this.unknownQueryMapper = QueryAnalyzer.buildMapper(queryTreeBuilders);
    }

    QueryAnalyzer() {
        this.unknownQueryMapper = (q, w) -> null;
    }

    private static BiFunction<Query, TermWeightor, QueryTree> buildMapper(List<CustomQueryHandler> mappers) {
        return (q, w) -> {
            for (CustomQueryHandler mapper : mappers) {
                QueryTree qt = mapper.handleQuery((Query)q, (TermWeightor)w);
                if (qt == null) continue;
                return qt;
            }
            return null;
        };
    }

    QueryTree buildTree(Query luceneQuery, TermWeightor weightor) {
        QueryBuilder builder = new QueryBuilder();
        luceneQuery.visit((QueryVisitor)builder);
        return builder.apply(weightor);
    }

    private class QueryBuilder
    extends QueryVisitor
    implements Function<TermWeightor, QueryTree> {
        final List<Function<TermWeightor, QueryTree>> children = new ArrayList<Function<TermWeightor, QueryTree>>();

        private QueryBuilder() {
        }

        public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
            BooleanQuery bq;
            long requiredCount;
            if (occur == BooleanClause.Occur.MUST || occur == BooleanClause.Occur.FILTER) {
                QueryBuilder n = new QueryBuilder();
                this.children.add(n);
                return n;
            }
            if (occur == BooleanClause.Occur.MUST_NOT) {
                BooleanQuery bq2;
                long positiveCount;
                if (parent instanceof BooleanQuery && (positiveCount = (bq2 = (BooleanQuery)parent).clauses().stream().filter(c -> c.occur() != BooleanClause.Occur.MUST_NOT).count()) == 0L) {
                    this.children.add(w -> QueryTree.anyTerm("PURE NEGATIVE QUERY[" + String.valueOf(parent) + "]"));
                }
                return QueryVisitor.EMPTY_VISITOR;
            }
            if (parent instanceof BooleanQuery && (requiredCount = (bq = (BooleanQuery)parent).clauses().stream().filter(c -> c.occur() == BooleanClause.Occur.MUST || c.occur() == BooleanClause.Occur.FILTER).count()) > 0L) {
                return QueryVisitor.EMPTY_VISITOR;
            }
            Disjunction n = new Disjunction(QueryAnalyzer.this);
            this.children.add(n);
            return n;
        }

        public void consumeTerms(Query query, Term ... terms) {
            for (Term term : terms) {
                this.children.add(w -> QueryTree.term(term, w));
            }
        }

        public void visitLeaf(Query query) {
            this.children.add(w -> {
                QueryTree q = QueryAnalyzer.this.unknownQueryMapper.apply(query, (TermWeightor)w);
                if (q == null) {
                    return QueryTree.anyTerm(query.toString());
                }
                return q;
            });
        }

        @Override
        public QueryTree apply(TermWeightor termWeightor) {
            return QueryTree.conjunction(this.children, termWeightor);
        }
    }

    private class Disjunction
    extends QueryBuilder {
        private Disjunction(QueryAnalyzer queryAnalyzer) {
        }

        @Override
        public QueryTree apply(TermWeightor termWeightor) {
            return QueryTree.disjunction(this.children, termWeightor);
        }
    }
}

