/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.compressing;

import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import java.util.Random;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsFormat;
import org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingTermVectorsFormat;
import org.apache.lucene.tests.codecs.compressing.DeflateWithPresetCompressingCodec;
import org.apache.lucene.tests.codecs.compressing.FastCompressingCodec;
import org.apache.lucene.tests.codecs.compressing.FastDecompressionCompressingCodec;
import org.apache.lucene.tests.codecs.compressing.HighCompressionCompressingCodec;
import org.apache.lucene.tests.codecs.compressing.LZ4WithPresetCompressingCodec;
import org.apache.lucene.tests.codecs.compressing.dummy.DummyCompressingCodec;
import org.apache.lucene.tests.util.TestUtil;

public abstract class CompressingCodec
extends FilterCodec {
    private final Lucene90CompressingStoredFieldsFormat storedFieldsFormat;
    private final Lucene90CompressingTermVectorsFormat termVectorsFormat;

    public static CompressingCodec randomInstance(Random random, int chunkSize, int maxDocsPerChunk, boolean withSegmentSuffix, int blockShift) {
        switch (random.nextInt(6)) {
            case 0: {
                return new FastCompressingCodec(chunkSize, maxDocsPerChunk, withSegmentSuffix, blockShift);
            }
            case 1: {
                return new FastDecompressionCompressingCodec(chunkSize, maxDocsPerChunk, withSegmentSuffix, blockShift);
            }
            case 2: {
                return new HighCompressionCompressingCodec(chunkSize, maxDocsPerChunk, withSegmentSuffix, blockShift);
            }
            case 3: {
                return new DummyCompressingCodec(chunkSize, maxDocsPerChunk, withSegmentSuffix, blockShift);
            }
            case 4: {
                return new DeflateWithPresetCompressingCodec(chunkSize, maxDocsPerChunk, withSegmentSuffix, blockShift);
            }
            case 5: {
                return new LZ4WithPresetCompressingCodec(chunkSize, maxDocsPerChunk, withSegmentSuffix, blockShift);
            }
        }
        throw new AssertionError();
    }

    public static CompressingCodec randomInstance(Random random) {
        int chunkSize = random.nextBoolean() ? RandomNumbers.randomIntBetween((Random)random, (int)10, (int)100) : RandomNumbers.randomIntBetween((Random)random, (int)10, (int)32768);
        int chunkDocs = random.nextBoolean() ? RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10) : RandomNumbers.randomIntBetween((Random)random, (int)64, (int)1024);
        int blockSize = random.nextBoolean() ? RandomNumbers.randomIntBetween((Random)random, (int)2, (int)10) : RandomNumbers.randomIntBetween((Random)random, (int)2, (int)22);
        return CompressingCodec.randomInstance(random, chunkSize, chunkDocs, false, blockSize);
    }

    public static CompressingCodec reasonableInstance(Random random) {
        int chunkSize = TestUtil.nextInt(random, 8192, 131072);
        int chunkDocs = TestUtil.nextInt(random, 64, 1024);
        int blockShift = TestUtil.nextInt(random, 8, 12);
        return CompressingCodec.randomInstance(random, chunkSize, chunkDocs, false, blockShift);
    }

    public static CompressingCodec randomInstance(Random random, boolean withSegmentSuffix) {
        return CompressingCodec.randomInstance(random, RandomNumbers.randomIntBetween((Random)random, (int)1, (int)32768), RandomNumbers.randomIntBetween((Random)random, (int)64, (int)1024), withSegmentSuffix, RandomNumbers.randomIntBetween((Random)random, (int)1, (int)1024));
    }

    public CompressingCodec(String name, String segmentSuffix, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) {
        super(name, TestUtil.getDefaultCodec());
        this.storedFieldsFormat = new Lucene90CompressingStoredFieldsFormat(name, segmentSuffix, compressionMode, chunkSize, maxDocsPerChunk, blockShift);
        this.termVectorsFormat = new Lucene90CompressingTermVectorsFormat(name, segmentSuffix, compressionMode, chunkSize, maxDocsPerChunk, blockShift);
    }

    public CompressingCodec(String name, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockSize) {
        this(name, "", compressionMode, chunkSize, maxDocsPerChunk, blockSize);
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public TermVectorsFormat termVectorsFormat() {
        return this.termVectorsFormat;
    }

    public String toString() {
        return this.getName() + "(storedFieldsFormat=" + String.valueOf(this.storedFieldsFormat) + ", termVectorsFormat=" + String.valueOf(this.termVectorsFormat) + ")";
    }
}

