/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.lucene.analysis.morph.DictionaryEntryWriter;
import org.apache.lucene.analysis.util.CSVUtil;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;

class TokenInfoDictionaryEntryWriter
extends DictionaryEntryWriter {
    private static final int ID_LIMIT = 8192;

    TokenInfoDictionaryEntryWriter(int size) {
        super(size);
    }

    protected int putEntry(String[] entry) {
        int i;
        short leftId = Short.parseShort(entry[1]);
        short rightId = Short.parseShort(entry[2]);
        short wordCost = Short.parseShort(entry[3]);
        StringBuilder sb = new StringBuilder();
        for (int i2 = 4; i2 < 8; ++i2) {
            String part = entry[i2];
            assert (part.length() > 0);
            if ("*".equals(part)) continue;
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(part);
        }
        String posData = sb.toString();
        if (posData.isEmpty()) {
            throw new IllegalArgumentException("POS fields are empty");
        }
        sb.setLength(0);
        sb.append(CSVUtil.quoteEscape((String)posData));
        sb.append(',');
        if (!"*".equals(entry[8])) {
            sb.append(CSVUtil.quoteEscape((String)entry[8]));
        }
        sb.append(',');
        if (!"*".equals(entry[9])) {
            sb.append(CSVUtil.quoteEscape((String)entry[9]));
        }
        String fullPOSData = sb.toString();
        String baseForm = entry[10];
        String reading = entry[11];
        String pronunciation = entry[12];
        int left = this.buffer.remaining();
        int worstCase = 7 + 2 * (baseForm.length() + reading.length() + pronunciation.length());
        if (worstCase > left) {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(ArrayUtil.oversize((int)(this.buffer.limit() + worstCase - left), (int)1));
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
        int flags = 0;
        if (baseForm.isEmpty()) {
            throw new IllegalArgumentException("base form is empty");
        }
        if (!"*".equals(baseForm) && !baseForm.equals(entry[0])) {
            flags |= 1;
        }
        if (!reading.equals(this.toKatakana(entry[0]))) {
            flags |= 2;
        }
        if (!pronunciation.equals(reading)) {
            flags |= 4;
        }
        if (leftId != rightId) {
            throw new IllegalArgumentException("rightId != leftId: " + rightId + " " + leftId);
        }
        if (leftId >= 8192) {
            throw new IllegalArgumentException("leftId >= 8192: " + leftId);
        }
        int toFill = 1 + leftId - this.posDict.size();
        for (int i3 = 0; i3 < toFill; ++i3) {
            this.posDict.add(null);
        }
        String existing = (String)this.posDict.get(leftId);
        if (existing != null && !existing.equals(fullPOSData)) {
            throw new IllegalArgumentException("Multiple entries found for leftID=" + leftId);
        }
        this.posDict.set(leftId, fullPOSData);
        this.buffer.putShort((short)(leftId << 3 | flags));
        this.buffer.putShort(wordCost);
        if ((flags & 1) != 0) {
            if (baseForm.length() >= 16) {
                throw new IllegalArgumentException("Length of base form " + baseForm + " is >= 16");
            }
            int shared = TokenInfoDictionaryEntryWriter.sharedPrefix(entry[0], baseForm);
            int suffix = baseForm.length() - shared;
            this.buffer.put((byte)(shared << 4 | suffix));
            for (int i4 = shared; i4 < baseForm.length(); ++i4) {
                this.buffer.putChar(baseForm.charAt(i4));
            }
        }
        if ((flags & 2) != 0) {
            if (this.isKatakana(reading)) {
                this.buffer.put((byte)(reading.length() << 1 | 1));
                this.writeKatakana(reading, this.buffer);
            } else {
                this.buffer.put((byte)(reading.length() << 1));
                for (i = 0; i < reading.length(); ++i) {
                    this.buffer.putChar(reading.charAt(i));
                }
            }
        }
        if ((flags & 4) != 0) {
            if (this.isKatakana(pronunciation)) {
                this.buffer.put((byte)(pronunciation.length() << 1 | 1));
                this.writeKatakana(pronunciation, this.buffer);
            } else {
                this.buffer.put((byte)(pronunciation.length() << 1));
                for (i = 0; i < pronunciation.length(); ++i) {
                    this.buffer.putChar(pronunciation.charAt(i));
                }
            }
        }
        return this.buffer.position();
    }

    private boolean isKatakana(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= '\u30a0' && ch <= '\u30ff') continue;
            return false;
        }
        return true;
    }

    private void writeKatakana(String s, ByteBuffer buffer) {
        for (int i = 0; i < s.length(); ++i) {
            buffer.put((byte)(s.charAt(i) - 12448));
        }
    }

    private String toKatakana(String s) {
        char[] text = new char[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            text[i] = ch > '\u3040' && ch < '\u3097' ? (char)(ch + 96) : ch;
        }
        return new String(text);
    }

    private static int sharedPrefix(String left, String right) {
        int len = left.length() < right.length() ? left.length() : right.length();
        for (int i = 0; i < len; ++i) {
            if (left.charAt(i) == right.charAt(i)) continue;
            return i;
        }
        return len;
    }

    protected void writePosDict(OutputStream bos, DataOutput out) throws IOException {
        out.writeVInt(this.posDict.size());
        for (String s : this.posDict) {
            if (s == null) {
                out.writeByte((byte)0);
                out.writeByte((byte)0);
                out.writeByte((byte)0);
                continue;
            }
            String[] data = CSVUtil.parse((String)s);
            if (data.length != 3) {
                throw new IllegalArgumentException("Malformed pos/inflection: " + s + "; expected 3 characters");
            }
            out.writeString(data[0]);
            out.writeString(data[1]);
            out.writeString(data[2]);
        }
    }
}

