/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.Closeable;
import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.DrillSideways;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeFacetCounts;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;

public class RangeFacetsExample
implements Closeable {
    private final Directory indexDir = new ByteBuffersDirectory();
    private IndexSearcher searcher;
    private LongRange[] logTimestampRanges = new LongRange[168];
    private final long nowSec = System.currentTimeMillis() / 1000L;
    final LongRange PAST_HOUR = new LongRange("Past hour", this.nowSec - 3600L, true, this.nowSec, true);
    final LongRange PAST_SIX_HOURS = new LongRange("Past six hours", this.nowSec - 21600L, true, this.nowSec, true);
    final LongRange PAST_DAY = new LongRange("Past day", this.nowSec - 86400L, true, this.nowSec, true);

    public void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        for (int i = 0; i < 100; ++i) {
            Document doc = new Document();
            long then = this.nowSec - (long)i * 1000L;
            doc.add((IndexableField)new NumericDocValuesField("timestamp", then));
            doc.add((IndexableField)new LongPoint("timestamp", new long[]{then}));
            indexWriter.addDocument((Iterable)doc);
        }
        long startTime = 0L;
        for (int i = 0; i < 168; ++i) {
            long endTime = (long)(i + 1) * 3600L;
            for (int j = 0; j < i % 35; ++j) {
                Document doc = new Document();
                Random r = new Random();
                long randomTimestamp = r.nextLong(1L, endTime - startTime) + startTime;
                doc.add((IndexableField)new NumericDocValuesField("error timestamp", randomTimestamp));
                doc.add((IndexableField)new StringField("error message", "server encountered error at " + randomTimestamp, Field.Store.NO));
                indexWriter.addDocument((Iterable)doc);
            }
            this.logTimestampRanges[i] = new LongRange("Hour " + i + "-" + (i + 1), startTime, false, endTime, true);
            startTime = endTime;
        }
        this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)indexWriter));
        indexWriter.close();
    }

    private FacetsConfig getConfig() {
        return new FacetsConfig();
    }

    public FacetResult search() throws IOException {
        FacetsCollector fc = FacetsCollectorManager.search((IndexSearcher)this.searcher, (Query)new MatchAllDocsQuery(), (int)10, (FacetsCollectorManager)new FacetsCollectorManager()).facetsCollector();
        LongRangeFacetCounts facets = new LongRangeFacetCounts("timestamp", fc, new LongRange[]{this.PAST_HOUR, this.PAST_SIX_HOURS, this.PAST_DAY});
        return facets.getAllChildren("timestamp", new String[0]);
    }

    public FacetResult searchTopChildren() throws IOException {
        FacetsCollectorManager fcm = new FacetsCollectorManager();
        FacetsCollector fc = FacetsCollectorManager.search((IndexSearcher)this.searcher, (Query)new MatchAllDocsQuery(), (int)10, (FacetsCollectorManager)fcm).facetsCollector();
        LongRangeFacetCounts facets = new LongRangeFacetCounts("error timestamp", fc, this.logTimestampRanges);
        return facets.getTopChildren(10, "error timestamp", new String[0]);
    }

    public TopDocs drillDown(LongRange range) throws IOException {
        DrillDownQuery q = new DrillDownQuery(this.getConfig());
        q.add("timestamp", LongPoint.newRangeQuery((String)"timestamp", (long)range.min, (long)range.max));
        return this.searcher.search((Query)q, 10);
    }

    public DrillSideways.DrillSidewaysResult drillSideways(LongRange range) throws IOException {
        DrillDownQuery q = new DrillDownQuery(this.getConfig());
        q.add("timestamp", LongPoint.newRangeQuery((String)"timestamp", (long)range.min, (long)range.max));
        DrillSideways.DrillSidewaysResult result = new DrillSideways(this.searcher, this.getConfig(), null, null){

            protected Facets buildFacetsResult(FacetsCollector drillDowns, FacetsCollector[] drillSideways, String[] drillSidewaysDims) throws IOException {
                assert (drillSidewaysDims[0].equals("timestamp"));
                return new LongRangeFacetCounts("timestamp", drillSideways[0], new LongRange[]{RangeFacetsExample.this.PAST_HOUR, RangeFacetsExample.this.PAST_SIX_HOURS, RangeFacetsExample.this.PAST_DAY});
            }
        }.search(q, 10);
        return result;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.searcher.getIndexReader(), this.indexDir});
    }

    public static void main(String[] args) throws Exception {
        RangeFacetsExample example = new RangeFacetsExample();
        example.index();
        System.out.println("Facet counting example:");
        System.out.println("-----------------------");
        System.out.println(example.search());
        System.out.println("\n");
        System.out.println("Facet counting example:");
        System.out.println("-----------------------");
        System.out.println(example.searchTopChildren());
        System.out.println("\n");
        System.out.println("Facet drill-down example (timestamp/Past six hours):");
        System.out.println("---------------------------------------------");
        TopDocs hits = example.drillDown(example.PAST_SIX_HOURS);
        System.out.println(String.valueOf(hits.totalHits) + " totalHits");
        System.out.println("\n");
        System.out.println("Facet drill-sideways example (timestamp/Past six hours):");
        System.out.println("---------------------------------------------");
        DrillSideways.DrillSidewaysResult sideways = example.drillSideways(example.PAST_SIX_HOURS);
        System.out.println(String.valueOf(sideways.hits.totalHits) + " totalHits");
        System.out.println(sideways.facets.getTopChildren(10, "timestamp", new String[0]));
        example.close();
    }
}

