/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.fragments.search;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.SearchTabOperator;
import org.apache.lucene.luke.app.desktop.components.fragments.search.SortTabOperator;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StringUtils;
import org.apache.lucene.luke.models.search.Search;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;

public final class SortPaneProvider
implements SortTabOperator {
    private static final String COMMAND_FIELD_COMBO1 = "fieldCombo1";
    private static final String COMMAND_FIELD_COMBO2 = "fieldCombo2";
    private final JComboBox<String> fieldCombo1 = new JComboBox();
    private final JComboBox<String> typeCombo1 = new JComboBox();
    private final JComboBox<String> orderCombo1 = new JComboBox<String>(Order.names());
    private final JComboBox<String> fieldCombo2 = new JComboBox();
    private final JComboBox<String> typeCombo2 = new JComboBox();
    private final JComboBox<String> orderCombo2 = new JComboBox<String>(Order.names());
    private final ListenerFunctions listeners = new ListenerFunctions();
    private final ComponentOperatorRegistry operatorRegistry = ComponentOperatorRegistry.getInstance();
    private Search searchModel;

    public SortPaneProvider() {
        this.operatorRegistry.register(SortTabOperator.class, this);
    }

    public JScrollPane get() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(this.initSortConfigsPanel());
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        return scrollPane;
    }

    private JPanel initSortConfigsPanel() {
        JPanel panel = new JPanel(new GridLayout(5, 1));
        panel.setOpaque(false);
        panel.setMaximumSize(new Dimension(500, 200));
        panel.add(new JLabel(MessageUtils.getLocalizedMessage("search_sort.label.primary")));
        JPanel primary = new JPanel(new FlowLayout(3));
        primary.setOpaque(false);
        primary.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        primary.add(new JLabel(MessageUtils.getLocalizedMessage("search_sort.label.field")));
        this.fieldCombo1.setPreferredSize(new Dimension(150, 30));
        this.fieldCombo1.setActionCommand(COMMAND_FIELD_COMBO1);
        this.fieldCombo1.addActionListener(this.listeners::changeField);
        primary.add(this.fieldCombo1);
        primary.add(new JLabel(MessageUtils.getLocalizedMessage("search_sort.label.type")));
        this.typeCombo1.setPreferredSize(new Dimension(130, 30));
        this.typeCombo1.addItem("");
        this.typeCombo1.setEnabled(false);
        primary.add(this.typeCombo1);
        primary.add(new JLabel(MessageUtils.getLocalizedMessage("search_sort.label.order")));
        this.orderCombo1.setPreferredSize(new Dimension(100, 30));
        this.orderCombo1.setEnabled(false);
        primary.add(this.orderCombo1);
        panel.add(primary);
        panel.add(new JLabel(MessageUtils.getLocalizedMessage("search_sort.label.secondary")));
        JPanel secondary = new JPanel(new FlowLayout(3));
        secondary.setOpaque(false);
        secondary.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        secondary.add(new JLabel(MessageUtils.getLocalizedMessage("search_sort.label.field")));
        this.fieldCombo2.setPreferredSize(new Dimension(150, 30));
        this.fieldCombo2.setActionCommand(COMMAND_FIELD_COMBO2);
        this.fieldCombo2.addActionListener(this.listeners::changeField);
        secondary.add(this.fieldCombo2);
        secondary.add(new JLabel(MessageUtils.getLocalizedMessage("search_sort.label.type")));
        this.typeCombo2.setPreferredSize(new Dimension(130, 30));
        this.typeCombo2.addItem("");
        this.typeCombo2.setEnabled(false);
        secondary.add(this.typeCombo2);
        secondary.add(new JLabel(MessageUtils.getLocalizedMessage("search_sort.label.order")));
        this.orderCombo2.setPreferredSize(new Dimension(100, 30));
        this.orderCombo2.setEnabled(false);
        secondary.add(this.orderCombo2);
        panel.add(secondary);
        JPanel clear = new JPanel(new FlowLayout(3));
        clear.setOpaque(false);
        JButton clearBtn = new JButton(MessageUtils.getLocalizedMessage("button.clear"));
        clearBtn.addActionListener(this.listeners::clear);
        clear.add(clearBtn);
        panel.add(clear);
        return panel;
    }

    @Override
    public void setSearchModel(Search model) {
        this.searchModel = model;
    }

    @Override
    public void setSortableFields(Collection<String> sortableFields) {
        this.fieldCombo1.removeAllItems();
        this.fieldCombo2.removeAllItems();
        this.fieldCombo1.addItem("");
        this.fieldCombo2.addItem("");
        for (String field : sortableFields) {
            this.fieldCombo1.addItem(field);
            this.fieldCombo2.addItem(field);
        }
    }

    @Override
    public Sort getSort() {
        if (StringUtils.isNullOrEmpty((String)this.fieldCombo1.getSelectedItem()) && StringUtils.isNullOrEmpty((String)this.fieldCombo2.getSelectedItem())) {
            return null;
        }
        ArrayList li = new ArrayList();
        if (!StringUtils.isNullOrEmpty((String)this.fieldCombo1.getSelectedItem())) {
            this.searchModel.getSortType((String)this.fieldCombo1.getSelectedItem(), (String)this.typeCombo1.getSelectedItem(), this.isReverse(this.orderCombo1)).ifPresent(li::add);
        }
        if (!StringUtils.isNullOrEmpty((String)this.fieldCombo2.getSelectedItem())) {
            this.searchModel.getSortType((String)this.fieldCombo2.getSelectedItem(), (String)this.typeCombo2.getSelectedItem(), this.isReverse(this.orderCombo2)).ifPresent(li::add);
        }
        return new Sort(li.toArray(new SortField[0]));
    }

    private boolean isReverse(JComboBox<String> order) {
        return Order.valueOf((String)order.getSelectedItem()) == Order.DESC;
    }

    static enum Order {
        ASC,
        DESC;


        static String[] names() {
            return (String[])Arrays.stream(Order.values()).map(Enum::name).toArray(String[]::new);
        }
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void changeField(ActionEvent e) {
            if (e.getActionCommand().equalsIgnoreCase(SortPaneProvider.COMMAND_FIELD_COMBO1)) {
                this.resetField(SortPaneProvider.this.fieldCombo1, SortPaneProvider.this.typeCombo1, SortPaneProvider.this.orderCombo1);
            } else if (e.getActionCommand().equalsIgnoreCase(SortPaneProvider.COMMAND_FIELD_COMBO2)) {
                this.resetField(SortPaneProvider.this.fieldCombo2, SortPaneProvider.this.typeCombo2, SortPaneProvider.this.orderCombo2);
            }
            this.resetExactHitsCnt();
        }

        private void resetField(JComboBox<String> fieldCombo, JComboBox<String> typeCombo, JComboBox<String> orderCombo) {
            typeCombo.removeAllItems();
            if (StringUtils.isNullOrEmpty((String)fieldCombo.getSelectedItem())) {
                typeCombo.addItem("");
                typeCombo.setEnabled(false);
                orderCombo.setEnabled(false);
            } else {
                List<SortField> sortFields = SortPaneProvider.this.searchModel.guessSortTypes((String)fieldCombo.getSelectedItem());
                sortFields.stream().map(sf -> {
                    if (sf instanceof SortedNumericSortField) {
                        return ((SortedNumericSortField)sf).getNumericType().name();
                    }
                    return sf.getType().name();
                }).forEach(typeCombo::addItem);
                typeCombo.setEnabled(true);
                orderCombo.setEnabled(true);
            }
        }

        void clear(ActionEvent e) {
            SortPaneProvider.this.fieldCombo1.setSelectedIndex(0);
            SortPaneProvider.this.typeCombo1.removeAllItems();
            SortPaneProvider.this.typeCombo1.setSelectedItem("");
            SortPaneProvider.this.typeCombo1.setEnabled(false);
            SortPaneProvider.this.orderCombo1.setSelectedIndex(0);
            SortPaneProvider.this.orderCombo1.setEnabled(false);
            SortPaneProvider.this.fieldCombo2.setSelectedIndex(0);
            SortPaneProvider.this.typeCombo2.removeAllItems();
            SortPaneProvider.this.typeCombo2.setSelectedItem("");
            SortPaneProvider.this.typeCombo2.setEnabled(false);
            SortPaneProvider.this.orderCombo2.setSelectedIndex(0);
            SortPaneProvider.this.orderCombo2.setEnabled(false);
            this.resetExactHitsCnt();
        }

        private void resetExactHitsCnt() {
            SortPaneProvider.this.operatorRegistry.get(SearchTabOperator.class).ifPresent(operator -> {
                if (StringUtils.isNullOrEmpty((String)SortPaneProvider.this.fieldCombo1.getSelectedItem()) && StringUtils.isNullOrEmpty((String)SortPaneProvider.this.fieldCombo2.getSelectedItem())) {
                    operator.enableExactHitsCB(true);
                    operator.setExactHits(false);
                } else {
                    operator.enableExactHitsCB(false);
                    operator.setExactHits(true);
                }
            });
        }
    }
}

