/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.documents;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.LukeModel;
import org.apache.lucene.luke.models.documents.DocValues;
import org.apache.lucene.luke.models.documents.DocValuesAdapter;
import org.apache.lucene.luke.models.documents.DocumentField;
import org.apache.lucene.luke.models.documents.Documents;
import org.apache.lucene.luke.models.documents.TermPosting;
import org.apache.lucene.luke.models.documents.TermVectorEntry;
import org.apache.lucene.luke.models.documents.TermVectorsAdapter;
import org.apache.lucene.luke.models.util.IndexUtils;
import org.apache.lucene.luke.util.BytesRefUtils;
import org.apache.lucene.luke.util.LoggerFactory;
import org.apache.lucene.util.BytesRef;

public final class DocumentsImpl
extends LukeModel
implements Documents {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TermVectorsAdapter tvAdapter;
    private final DocValuesAdapter dvAdapter;
    private String curField;
    private TermsEnum tenum;
    private PostingsEnum penum;

    public DocumentsImpl(IndexReader reader) {
        super(reader);
        this.tvAdapter = new TermVectorsAdapter(reader);
        this.dvAdapter = new DocValuesAdapter(reader);
    }

    @Override
    public int getMaxDoc() {
        return this.reader.maxDoc();
    }

    @Override
    public boolean isLive(int docid) {
        return this.liveDocs == null || this.liveDocs.get(docid);
    }

    @Override
    public List<DocumentField> getDocumentFields(int docid) {
        if (!this.isLive(docid)) {
            log.info("Doc #" + docid + " was deleted");
            return Collections.emptyList();
        }
        ArrayList<DocumentField> res = new ArrayList<DocumentField>();
        try {
            Document doc = this.reader.storedFields().document(docid);
            for (FieldInfo finfo : IndexUtils.getFieldInfos(this.reader)) {
                IndexableField[] fields = doc.getFields(finfo.name);
                if (fields.length == 0) {
                    res.add(DocumentField.of(finfo, this.reader, docid));
                    continue;
                }
                for (IndexableField field : fields) {
                    res.add(DocumentField.of(finfo, field, this.reader, docid));
                }
            }
        }
        catch (IOException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Fields information not available for doc %d.", docid), e);
        }
        return res;
    }

    @Override
    public String getCurrentField() {
        return this.curField;
    }

    @Override
    public Optional<Term> firstTerm(String field) {
        Objects.requireNonNull(field);
        try {
            Terms terms = IndexUtils.getTerms(this.reader, field);
            if (terms == null) {
                this.resetCurrentField();
                this.resetTermsIterator();
                log.warning("Terms not available for field: " + field);
                Optional<Term> optional = Optional.empty();
                return optional;
            }
            this.setCurrentField(field);
            this.setTermsIterator(terms.iterator());
            if (this.tenum.next() == null) {
                this.resetTermsIterator();
                log.warning("No term available for field: " + field);
                Optional<Term> optional = Optional.empty();
                return optional;
            }
            Optional<Term> optional = Optional.of(new Term(this.curField, this.tenum.term()));
            return optional;
        }
        catch (IOException e) {
            this.resetTermsIterator();
            throw new LukeException(String.format(Locale.ENGLISH, "Terms not available for field: %s.", field), e);
        }
        finally {
            this.resetPostingsIterator();
        }
    }

    @Override
    public Optional<Term> nextTerm() {
        if (this.tenum == null) {
            log.warning("Terms enum un-positioned.");
            return Optional.empty();
        }
        try {
            if (this.tenum.next() == null) {
                this.resetTermsIterator();
                log.info("Reached the end of the term iterator for field: " + this.curField);
                Optional<Term> optional = Optional.empty();
                return optional;
            }
            Optional<Term> optional = Optional.of(new Term(this.curField, this.tenum.term()));
            return optional;
        }
        catch (IOException e) {
            this.resetTermsIterator();
            throw new LukeException(String.format(Locale.ENGLISH, "Terms not available for field: %s.", this.curField), e);
        }
        finally {
            this.resetPostingsIterator();
        }
    }

    @Override
    public Optional<Term> seekTerm(String termText) {
        Objects.requireNonNull(termText);
        if (this.curField == null) {
            log.warning("Field not selected.");
            return Optional.empty();
        }
        try {
            Terms terms = IndexUtils.getTerms(this.reader, this.curField);
            this.setTermsIterator(terms.iterator());
            if (this.tenum.seekCeil(new BytesRef((CharSequence)termText)) == TermsEnum.SeekStatus.END) {
                this.resetTermsIterator();
                log.info("Reached the end of the term iterator for field: " + this.curField);
                Optional<Term> optional = Optional.empty();
                return optional;
            }
            Optional<Term> optional = Optional.of(new Term(this.curField, this.tenum.term()));
            return optional;
        }
        catch (IOException e) {
            this.resetTermsIterator();
            throw new LukeException(String.format(Locale.ENGLISH, "Terms not available for field: %s.", this.curField), e);
        }
        finally {
            this.resetPostingsIterator();
        }
    }

    @Override
    public Optional<Integer> firstTermDoc() {
        if (this.tenum == null) {
            log.warning("Terms enum un-positioned.");
            return Optional.empty();
        }
        try {
            this.setPostingsIterator(this.tenum.postings(this.penum, 120));
            if (this.penum.nextDoc() == Integer.MAX_VALUE) {
                this.resetPostingsIterator();
                log.warning("No docs available for term: " + BytesRefUtils.decode(this.tenum.term()) + " in field: " + this.curField);
                return Optional.empty();
            }
            return Optional.of(this.penum.docID());
        }
        catch (IOException e) {
            this.resetPostingsIterator();
            throw new LukeException(String.format(Locale.ENGLISH, "Term docs not available for field: %s.", this.curField), e);
        }
    }

    @Override
    public Optional<Integer> nextTermDoc() {
        if (this.penum == null) {
            log.warning("Postings enum un-positioned for field: " + this.curField);
            return Optional.empty();
        }
        try {
            if (this.penum.nextDoc() == Integer.MAX_VALUE) {
                this.resetPostingsIterator();
                log.info("Reached the end of the postings iterator for term: " + BytesRefUtils.decode(this.tenum.term()) + " in field: " + this.curField);
                return Optional.empty();
            }
            return Optional.of(this.penum.docID());
        }
        catch (IOException e) {
            this.resetPostingsIterator();
            throw new LukeException(String.format(Locale.ENGLISH, "Term docs not available for field: %s.", this.curField), e);
        }
    }

    @Override
    public List<TermPosting> getTermPositions() {
        if (this.penum == null) {
            log.warning("Postings enum un-positioned for field: " + this.curField);
            return Collections.emptyList();
        }
        ArrayList<TermPosting> res = new ArrayList<TermPosting>();
        try {
            int freq = this.penum.freq();
            for (int i = 0; i < freq; ++i) {
                int position = this.penum.nextPosition();
                if (position < 0) continue;
                TermPosting posting = TermPosting.of(position, this.penum);
                res.add(posting);
            }
        }
        catch (IOException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Postings not available for field %s.", this.curField), e);
        }
        return res;
    }

    @Override
    public Optional<Integer> getDocFreq() {
        if (this.tenum == null) {
            log.warning("Terms enum un-positioned for field: " + this.curField);
            return Optional.empty();
        }
        try {
            return Optional.of(this.tenum.docFreq());
        }
        catch (IOException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Doc frequency not available for field: %s.", this.curField), e);
        }
    }

    @Override
    public List<TermVectorEntry> getTermVectors(int docid, String field) {
        try {
            return this.tvAdapter.getTermVector(docid, field);
        }
        catch (IOException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Term vector not available for doc: #%d and field: %s", docid, field), e);
        }
    }

    @Override
    public Optional<DocValues> getDocValues(int docid, String field) {
        try {
            return this.dvAdapter.getDocValues(docid, field);
        }
        catch (IOException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Doc values not available for doc: #%d and field: %s", docid, field), e);
        }
    }

    private void resetCurrentField() {
        this.curField = null;
    }

    private void setCurrentField(String field) {
        this.curField = field;
    }

    private void resetTermsIterator() {
        this.tenum = null;
    }

    private void setTermsIterator(TermsEnum tenum) {
        this.tenum = tenum;
    }

    private void resetPostingsIterator() {
        this.penum = null;
    }

    private void setPostingsIterator(PostingsEnum penum) {
        this.penum = penum;
    }
}

