/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.media;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.mov.QuickTimeContext;
import com.drew.metadata.mov.QuickTimeMediaHandler;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.atoms.TimeToSampleAtom;
import com.drew.metadata.mov.atoms.VideoInformationMediaHeaderAtom;
import com.drew.metadata.mov.atoms.VideoSampleDescriptionAtom;
import com.drew.metadata.mov.media.QuickTimeVideoDirectory;
import java.io.IOException;

public class QuickTimeVideoHandler
extends QuickTimeMediaHandler<QuickTimeVideoDirectory> {
    public QuickTimeVideoHandler(Metadata metadata, QuickTimeContext context) {
        super(metadata, context);
    }

    @Override
    protected String getMediaInformation() {
        return "vmhd";
    }

    @Override
    @NotNull
    protected QuickTimeVideoDirectory getDirectory() {
        return new QuickTimeVideoDirectory();
    }

    @Override
    public void processSampleDescription(@NotNull SequentialReader reader, @NotNull Atom atom) throws IOException {
        VideoSampleDescriptionAtom videoSampleDescriptionAtom = new VideoSampleDescriptionAtom(reader, atom);
        videoSampleDescriptionAtom.addMetadata((QuickTimeVideoDirectory)this.directory);
    }

    @Override
    public void processMediaInformation(@NotNull SequentialReader reader, @NotNull Atom atom) throws IOException {
        VideoInformationMediaHeaderAtom videoInformationMediaHeaderAtom = new VideoInformationMediaHeaderAtom(reader, atom);
        videoInformationMediaHeaderAtom.addMetadata((QuickTimeVideoDirectory)this.directory);
    }

    @Override
    public void processTimeToSample(@NotNull SequentialReader reader, @NotNull Atom atom, QuickTimeContext context) throws IOException {
        TimeToSampleAtom timeToSampleAtom = new TimeToSampleAtom(reader, atom);
        timeToSampleAtom.addMetadata((QuickTimeVideoDirectory)this.directory, context);
    }
}

