/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.CDM;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;
import ucar.nc2.util.URLnaming;
import ucar.unidata.util.StringUtil2;

public class NCdump {
    private static boolean debugSelector = false;
    private static String usage = "usage: NCdump <filename> [-cdl | -ncml] [-c | -vall] [-v varName1;varName2;..] [-v varName(0:1,:,12)]\n";
    private static int totalWidth = 80;
    private static char[] org = new char[]{'\b', '\f', '\n', '\r', '\t', '\\', '\'', '\"'};
    private static String[] replace = new String[]{"\\b", "\\f", "\\n", "\\r", "\\t", "\\\\", "\\'", "\\\""};

    public static boolean printHeader(String fileName, OutputStream out) throws IOException {
        return NCdump.print(fileName, out, false, false, false, false, null, null);
    }

    public static boolean printNcML(String fileName, OutputStream out) throws IOException {
        return NCdump.print(fileName, out, false, true, true, false, null, null);
    }

    public static boolean print(String command, OutputStream out) throws IOException {
        return NCdump.print(command, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean print(String command, OutputStream out, CancelTask ct) throws IOException {
        StringTokenizer stoke = new StringTokenizer(command);
        if (!stoke.hasMoreTokens()) {
            out.write(usage.getBytes(CDM.utf8Charset));
            return false;
        }
        String filename = stoke.nextToken();
        try (NetcdfFile nc = null;){
            nc = NetcdfFile.open(filename, ct);
            int pos = command.indexOf(filename);
            command = command.substring(pos + filename.length());
            boolean bl = NCdump.print(nc, command, out, ct);
            return bl;
        }
    }

    public static boolean print(NetcdfFile nc, String command, OutputStream out, CancelTask ct) throws IOException {
        boolean showAll = false;
        boolean showCoords = false;
        boolean ncml = false;
        boolean strict = false;
        String varNames = null;
        if (command != null) {
            StringTokenizer stoke = new StringTokenizer(command);
            while (stoke.hasMoreTokens()) {
                String toke = stoke.nextToken();
                if (toke.equalsIgnoreCase("-help")) {
                    out.write(usage.getBytes(CDM.utf8Charset));
                    out.write(10);
                    return true;
                }
                if (toke.equalsIgnoreCase("-vall")) {
                    showAll = true;
                }
                if (toke.equalsIgnoreCase("-c")) {
                    showCoords = true;
                }
                if (toke.equalsIgnoreCase("-ncml")) {
                    ncml = true;
                }
                if (toke.equalsIgnoreCase("-cdl")) {
                    strict = true;
                }
                if (!toke.equalsIgnoreCase("-v") || !stoke.hasMoreTokens()) continue;
                varNames = stoke.nextToken();
            }
        }
        return NCdump.print(nc, out, showAll, showCoords, ncml, strict, varNames, ct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean print(String fileName, OutputStream out, boolean showAll, boolean showCoords, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        try (NetcdfFile nc = null;){
            nc = NetcdfFile.open(fileName, ct);
            boolean bl = NCdump.print(nc, out, showAll, showCoords, ncml, strict, varNames, ct);
            return bl;
        }
    }

    public static boolean print(NetcdfFile nc, OutputStream out, boolean showAll, boolean showCoords, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
        return NCdumpW.print(nc, (Writer)pw, showAll, showCoords, ncml, strict, varNames, ct);
    }

    private static CEresult parseVariableSection(NetcdfFile ncfile, String variableSection) throws InvalidRangeException {
        StringTokenizer stoke = new StringTokenizer(variableSection, ".");
        String selector = stoke.nextToken();
        if (selector == null) {
            throw new IllegalArgumentException("empty sectionSpec = " + variableSection);
        }
        boolean hasInner = false;
        ArrayList<Range> fullSelection = new ArrayList<Range>();
        Variable innerV = NCdump.parseVariableSelector(ncfile, selector, fullSelection);
        while (stoke.hasMoreTokens()) {
            selector = stoke.nextToken();
            innerV = NCdump.parseVariableSelector(innerV, selector, fullSelection);
            hasInner = true;
        }
        return new CEresult(innerV, fullSelection, hasInner);
    }

    private static Variable parseVariableSelector(Object parent, String selector, List<Range> fullSelection) throws InvalidRangeException {
        Section section;
        String varName;
        String indexSelect = null;
        int pos1 = selector.indexOf(40);
        if (pos1 < 0) {
            varName = selector;
        } else {
            varName = selector.substring(0, pos1);
            indexSelect = selector.substring(pos1);
        }
        if (debugSelector) {
            System.out.println(" parseVariableSection <" + selector + "> = <" + varName + ">, <" + indexSelect + ">");
        }
        Variable v = null;
        if (parent instanceof NetcdfFile) {
            NetcdfFile ncfile = (NetcdfFile)parent;
            v = ncfile.findVariable(varName);
        } else if (parent instanceof Structure) {
            Structure s = (Structure)parent;
            v = s.findVariable(varName);
        }
        if (v == null) {
            throw new IllegalArgumentException(" cant find variable: " + varName + " in selector=" + selector);
        }
        if (indexSelect != null) {
            section = new Section(indexSelect);
            section.setDefaults(v.getShape());
        } else {
            section = new Section(v.getShape());
        }
        fullSelection.addAll(section.getRanges());
        return v;
    }

    public static String makeSectionString(VariableIF v, List<Range> ranges) throws InvalidRangeException {
        StringBuilder sb = new StringBuilder();
        NCdump.makeSpec(sb, v, ranges);
        return sb.toString();
    }

    private static List<Range> makeSpec(StringBuilder sb, VariableIF v, List<Range> orgRanges) throws InvalidRangeException {
        if (v.isMemberOfStructure()) {
            orgRanges = NCdump.makeSpec(sb, v.getParentStructure(), orgRanges);
            sb.append('.');
        }
        List<Range> ranges = orgRanges == null ? v.getRanges() : orgRanges;
        sb.append(v.isMemberOfStructure() ? v.getShortName() : v.getFullNameEscaped());
        if (!v.isVariableLength() && !v.isScalar()) {
            sb.append('(');
            for (int count = 0; count < v.getRank(); ++count) {
                Range r = ranges.get(count);
                if (r == null) {
                    r = new Range(0, v.getDimension(count).getLength());
                }
                if (count > 0) {
                    sb.append(", ");
                }
                sb.append(r.first());
                sb.append(':');
                sb.append(r.last());
                sb.append(':');
                sb.append(r.stride());
            }
            sb.append(')');
        }
        return orgRanges == null ? null : ranges.subList(v.getRank(), ranges.size());
    }

    public static String printVariableData(VariableIF v, CancelTask ct) throws IOException {
        Array data = v.read();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        NCdump.printArray(data, v.getFullName(), new PrintStream(bos), ct);
        return bos.toString();
    }

    public static String printVariableDataSection(VariableIF v, String sectionSpec, CancelTask ct) throws IOException, InvalidRangeException {
        Array data = v.read(sectionSpec);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        NCdump.printArray(data, v.getFullName(), new PrintStream(bos), ct);
        return bos.toString();
    }

    public static void printArray(Array array, String name, PrintStream out, CancelTask ct) {
        NCdump.printArray(array, name, null, out, new Indent(2), ct);
    }

    private static void printArray(Array array, String name, String units, PrintStream out, Indent ilev, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        if (name != null) {
            out.print(ilev + name + " =");
        }
        ilev.incr();
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        if (array instanceof ArrayChar && array.getRank() > 0) {
            NCdump.printStringArray(out, (ArrayChar)array, ilev, ct);
        } else if (array.getElementType() == String.class) {
            NCdump.printStringArray(out, (ArrayObject)array, ilev, ct);
        } else if (array.getElementType() == StructureData.class) {
            if (array.getSize() == 1L) {
                NCdump.printStructureData(out, (StructureData)array.getObject(array.getIndex()), ilev, ct);
            } else {
                NCdump.printStructureDataArray(out, array, ilev, ct);
            }
        } else {
            NCdump.printArray(array, out, ilev, ct);
        }
        if (units != null) {
            out.print(" " + units);
        }
        out.print("\n");
        ilev.decr();
    }

    private static void printArray(Array ma, PrintStream out, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            out.print(ma.getObject(ima).toString());
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        if (rank == 1 && ma.getElementType() != StructureData.class) {
            for (int ii = 0; ii < last; ++ii) {
                out.print(ma.getObject(ima.set(ii)).toString());
                if (ii != last - 1) {
                    out.print(", ");
                }
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            out.print("}");
            return;
        }
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            Array slice = ma.slice(0, ii);
            NCdump.printArray(slice, out, indent, ct);
            if (ii != last - 1) {
                out.print(",");
            }
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    static void printStringArray(PrintStream out, ArrayChar ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        if (rank == 1) {
            out.print("  \"" + ma.getString() + "\"");
            return;
        }
        if (rank == 2) {
            boolean first = true;
            ArrayChar.StringIterator iter = ma.getStringIterator();
            while (iter.hasNext()) {
                if (!first) {
                    out.print(", ");
                }
                out.print("\"" + iter.next() + "\"");
                first = false;
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayChar slice = (ArrayChar)ma.slice(0, ii);
            NCdump.printStringArray(out, slice, indent, ct);
            if (ii != last - 1) {
                out.print(",");
            }
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    static void printStringArray(PrintStream out, ArrayObject ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            out.print("  \"" + ma.getObject(ima) + "\"");
            return;
        }
        if (rank == 1) {
            boolean first = true;
            int i = 0;
            while ((long)i < ma.getSize()) {
                if (!first) {
                    out.print(", ");
                }
                out.print("  \"" + ma.getObject(ima.set(i)) + "\"");
                first = false;
                ++i;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayObject slice = (ArrayObject)ma.slice(0, ii);
            NCdump.printStringArray(out, slice, indent, ct);
            if (ii == last - 1) continue;
            out.print(",");
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    private static void printStructureDataArray(PrintStream out, Array array, Indent indent, CancelTask ct) {
        IndexIterator ii = array.getIndexIterator();
        while (ii.hasNext()) {
            StructureData sdata = (StructureData)ii.next();
            out.println("\n" + indent + "{");
            NCdump.printStructureData(out, sdata, indent, ct);
            out.print(indent + "} " + sdata.getName() + "(" + ii + ")");
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
    }

    public static void printStructureData(PrintStream out, StructureData sdata) {
        NCdump.printStructureData(out, sdata, new Indent(2), null);
    }

    private static void printStructureData(PrintStream out, StructureData sdata, Indent indent, CancelTask ct) {
        indent.incr();
        for (StructureMembers.Member m : sdata.getMembers()) {
            Array sdataArray = sdata.getArray(m);
            NCdump.printArray(sdataArray, m.getName(), m.getUnitsString(), out, indent, ct);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
    }

    public static void writeNcML(NetcdfFile ncfile, OutputStream os, boolean showCoords, String uri) throws IOException {
        PrintStream out = new PrintStream(os);
        out.print("<?xml version='1.0' encoding='UTF-8'?>\n");
        out.print("<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'\n");
        if (uri != null) {
            out.print("    location='" + StringUtil2.quoteXmlAttribute(uri) + "' >\n\n");
        } else {
            out.print("    location='" + StringUtil2.quoteXmlAttribute(URLnaming.canonicalizeWrite(ncfile.getLocation())) + "' >\n\n");
        }
        if (ncfile.getId() != null) {
            out.print("    id='" + StringUtil2.quoteXmlAttribute(ncfile.getId()) + "' >\n");
        }
        if (ncfile.getTitle() != null) {
            out.print("    title='" + StringUtil2.quoteXmlAttribute(ncfile.getTitle()) + "' >\n");
        }
        NCdump.writeNcMLGroup(ncfile, ncfile.getRootGroup(), out, new Indent(2), showCoords);
        out.print("</netcdf>\n");
        out.flush();
    }

    private static void writeNcMLGroup(NetcdfFile ncfile, Group g, PrintStream out, Indent indent, boolean showCoords) throws IOException {
        if (g != ncfile.getRootGroup()) {
            out.print(indent);
            out.print("<group name='" + StringUtil2.quoteXmlAttribute(g.getShortName()) + "' >\n");
        }
        indent.incr();
        List<Dimension> dimList = g.getDimensions();
        for (Dimension dim : dimList) {
            out.print(indent);
            out.print("<dimension name='" + StringUtil2.quoteXmlAttribute(dim.getShortName()) + "' length='" + dim.getLength() + "'");
            if (dim.isUnlimited()) {
                out.print(" isUnlimited='true'");
            }
            out.print(" />\n");
        }
        if (dimList.size() > 0) {
            out.print("\n");
        }
        List<Attribute> attList = g.getAttributes();
        for (Attribute att : attList) {
            NCdump.writeNcMLAtt(att, out, indent);
        }
        if (attList.size() > 0) {
            out.print("\n");
        }
        for (Variable v : g.getVariables()) {
            if (v instanceof Structure) {
                NCdump.writeNcMLStructure((Structure)v, out, indent);
                continue;
            }
            NCdump.writeNcMLVariable(v, out, indent, showCoords);
        }
        List<Group> groupList = g.getGroups();
        for (int i = 0; i < groupList.size(); ++i) {
            if (i > 0) {
                out.print("\n");
            }
            Group nested = groupList.get(i);
            NCdump.writeNcMLGroup(ncfile, nested, out, indent, showCoords);
        }
        indent.decr();
        if (g != ncfile.getRootGroup()) {
            out.print(indent);
            out.print("</group>\n");
        }
    }

    private static void writeNcMLStructure(Structure s, PrintStream out, Indent indent) throws IOException {
        out.print(indent);
        out.print("<structure name='" + StringUtil2.quoteXmlAttribute(s.getShortName()));
        if (s.getRank() > 0) {
            NCdump.writeNcMLDimension(s, out);
        }
        out.print(">\n");
        indent.incr();
        List<Attribute> attList = s.getAttributes();
        for (Attribute att : attList) {
            NCdump.writeNcMLAtt(att, out, indent);
        }
        if (attList.size() > 0) {
            out.print("\n");
        }
        List<Variable> varList = s.getVariables();
        for (Variable v : varList) {
            NCdump.writeNcMLVariable(v, out, indent, false);
        }
        indent.decr();
        out.print(indent);
        out.print("</structure>\n");
    }

    private static void writeNcMLVariable(Variable v, PrintStream out, Indent indent, boolean showCoords) throws IOException {
        out.print(indent);
        out.print("<variable name='" + StringUtil2.quoteXmlAttribute(v.getShortName()) + "' type='" + (Object)((Object)v.getDataType()) + "'");
        if (v.getRank() > 0) {
            NCdump.writeNcMLDimension(v, out);
        }
        indent.incr();
        boolean closed = false;
        List<Attribute> atts = v.getAttributes();
        if (atts.size() > 0) {
            out.print(" >\n");
            closed = true;
            for (Attribute att : atts) {
                NCdump.writeNcMLAtt(att, out, indent);
            }
        }
        if (showCoords && v.isCoordinateVariable()) {
            if (!closed) {
                out.print(" >\n");
                closed = true;
            }
            NCdump.writeNcMLValues(v, out, indent);
        }
        indent.decr();
        if (!closed) {
            out.print(" />\n");
        } else {
            out.print(indent);
            out.print("</variable>\n");
        }
    }

    private static void writeNcMLDimension(Variable v, PrintStream out) {
        out.print(" shape='");
        List<Dimension> dims = v.getDimensions();
        for (int j = 0; j < dims.size(); ++j) {
            Dimension dim = dims.get(j);
            if (j != 0) {
                out.print(" ");
            }
            if (dim.isShared()) {
                out.print(StringUtil2.quoteXmlAttribute(dim.getShortName()));
                continue;
            }
            out.print(dim.getLength());
        }
        out.print("'");
    }

    private static void writeNcMLAtt(Attribute att, PrintStream out, Indent indent) {
        out.print(indent);
        out.print("<attribute name='" + StringUtil2.quoteXmlAttribute(att.getShortName()) + "' value='");
        if (att.isString()) {
            for (int i = 0; i < att.getLength(); ++i) {
                if (i > 0) {
                    out.print("\\, ");
                }
                out.print(StringUtil2.quoteXmlAttribute(att.getStringValue(i)));
            }
        } else {
            for (int i = 0; i < att.getLength(); ++i) {
                if (i > 0) {
                    out.print(" ");
                }
                out.print(att.getNumericValue(i) + " ");
            }
            out.print("' type='" + (Object)((Object)att.getDataType()));
        }
        out.print("' />\n");
    }

    private static void writeNcMLValues(Variable v, PrintStream out, Indent indent) throws IOException {
        Array data = v.read();
        int width = NCdump.formatValues(indent + "<values>", out, 0, indent);
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            width = NCdump.formatValues(ii.next() + " ", out, width, indent);
        }
        NCdump.formatValues("</values>\n", out, width, indent);
    }

    private static int formatValues(String s, PrintStream out, int width, Indent indent) {
        int len = s.length();
        if (len + width > totalWidth) {
            out.print("\n");
            out.print(indent);
            width = indent.toString().length();
        }
        out.print(s);
        return width += len;
    }

    public static String encodeString(String s) {
        return StringUtil2.replace(s, org, replace);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(usage);
            return;
        }
        StringBuilder sbuff = new StringBuilder();
        for (String arg : args) {
            sbuff.append(arg);
            sbuff.append(" ");
        }
        try {
            NCdump.print(sbuff.toString(), System.out, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static class CEresult {
        public Variable v;
        public List<Range> ranges;
        public boolean hasInner;

        CEresult(Variable v, List<Range> ranges, boolean hasInner) {
            this.v = v;
            this.ranges = ranges;
            this.hasInner = hasInner;
        }
    }
}

