/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.internal.transformation.TransformerManager;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.spi.artifact.transformer.ArtifactTransformer;

@Singleton
@Named
final class MavenTransformer
implements ArtifactTransformer {
    private final TransformerManager transformerManager;

    @Inject
    MavenTransformer(TransformerManager transformerManager) {
        this.transformerManager = Objects.requireNonNull(transformerManager);
    }

    public InstallRequest transformInstallArtifacts(RepositorySystemSession session, InstallRequest request) {
        return this.transformerManager.remapInstallArtifacts(session, request);
    }

    public DeployRequest transformDeployArtifacts(RepositorySystemSession session, DeployRequest request) {
        return this.transformerManager.remapDeployArtifacts(session, request);
    }
}

