/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cache.CacheMetadata;
import org.apache.maven.api.cache.CacheRetention;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.Source;

@Experimental
public final class Sources {
    private Sources() {
    }

    @Nonnull
    public static Source fromPath(@Nonnull Path path) {
        return new PathSource(Objects.requireNonNull(path, "path"));
    }

    @Nonnull
    public static ModelSource buildSource(@Nonnull Path path) {
        return new BuildPathSource(Objects.requireNonNull(path, "path"));
    }

    @Nonnull
    public static ModelSource resolvedSource(@Nonnull Path path, @Nullable String location) {
        return new ResolvedPathSource(Objects.requireNonNull(path, "path"), location);
    }

    static class PathSource
    implements Source {
        @Nonnull
        protected final Path path;
        @Nonnull
        protected final String location;

        PathSource(Path path) {
            this(path, null);
        }

        protected PathSource(Path path, String location) {
            this.path = Objects.requireNonNull(path, "path").normalize();
            this.location = location != null ? location : this.path.toString();
        }

        @Override
        @Nullable
        public Path getPath() {
            return this.path;
        }

        @Override
        @Nonnull
        public InputStream openStream() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        @Override
        @Nonnull
        public String getLocation() {
            return this.location;
        }

        @Override
        @Nullable
        public Source resolve(@Nonnull String relative) {
            return new PathSource(this.path.resolve(relative));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) return true;
            if (!(o instanceof PathSource)) return false;
            PathSource that = (PathSource)o;
            if (!Objects.equals(this.path, that.path)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[location='" + this.location + "', path=" + String.valueOf(this.path) + "]";
        }
    }

    static class BuildPathSource
    extends PathSource
    implements ModelSource,
    CacheMetadata {
        BuildPathSource(Path path) {
            super(path, null);
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public Source resolve(@Nonnull String relative) {
            return new BuildPathSource(this.path.resolve(relative));
        }

        @Override
        @Nullable
        public ModelSource resolve(@Nonnull ModelSource.ModelLocator locator, @Nonnull String relative) {
            String norm = relative.replace('\\', File.separatorChar).replace('/', File.separatorChar);
            Path path = this.getPath().getParent().resolve(norm);
            Path relatedPom = locator.locateExistingPom(path);
            if (relatedPom != null) {
                return new BuildPathSource(relatedPom);
            }
            return null;
        }

        @Override
        public CacheRetention getCacheRetention() {
            return CacheRetention.REQUEST_SCOPED;
        }
    }

    static class ResolvedPathSource
    extends PathSource
    implements ModelSource {
        ResolvedPathSource(Path path, String location) {
            super(path, location);
        }

        @Override
        public Path getPath() {
            return null;
        }

        @Override
        public Source resolve(String relative) {
            return null;
        }

        @Override
        @Nullable
        public ModelSource resolve(@Nonnull ModelSource.ModelLocator modelLocator, @Nonnull String relative) {
            return null;
        }
    }
}

