/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.checksum;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.checksum.FileTrustedChecksumsSourceSupport;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.io.ChecksumProcessor;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.repository.RepositoryIdHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="sparseDirectory")
public final class SparseDirectoryTrustedChecksumsSource
extends FileTrustedChecksumsSourceSupport {
    public static final String NAME = "sparseDirectory";
    private static final String CONFIG_PROPS_PREFIX = "aether.trustedChecksumsSource.sparseDirectory.";
    public static final String CONFIG_PROP_ENABLED = "aether.trustedChecksumsSource.sparseDirectory";
    public static final String CONFIG_PROP_BASEDIR = "aether.trustedChecksumsSource.sparseDirectory.basedir";
    public static final String LOCAL_REPO_PREFIX_DIR = ".checksums";
    public static final String CONFIG_PROP_ORIGIN_AWARE = "aether.trustedChecksumsSource.sparseDirectory.originAware";
    private static final Logger LOGGER = LoggerFactory.getLogger(SparseDirectoryTrustedChecksumsSource.class);
    private final ChecksumProcessor checksumProcessor;
    private final LocalPathComposer localPathComposer;

    @Inject
    public SparseDirectoryTrustedChecksumsSource(ChecksumProcessor checksumProcessor, LocalPathComposer localPathComposer) {
        this.checksumProcessor = Objects.requireNonNull(checksumProcessor);
        this.localPathComposer = Objects.requireNonNull(localPathComposer);
    }

    @Override
    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_ENABLED});
    }

    private boolean isOriginAware(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{CONFIG_PROP_ORIGIN_AWARE});
    }

    @Override
    protected Map<String, String> doGetTrustedArtifactChecksums(RepositorySystemSession session, Artifact artifact, ArtifactRepository artifactRepository, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        boolean originAware = this.isOriginAware(session);
        HashMap<String, String> checksums = new HashMap<String, String>();
        Path basedir = this.getBasedir(session, LOCAL_REPO_PREFIX_DIR, CONFIG_PROP_BASEDIR, false);
        if (Files.isDirectory(basedir, new LinkOption[0])) {
            for (ChecksumAlgorithmFactory checksumAlgorithmFactory : checksumAlgorithmFactories) {
                Path checksumPath = basedir.resolve(this.calculateArtifactPath(originAware, artifact, (String)RepositoryIdHelper.cachedIdToPathSegment((RepositorySystemSession)session).apply(artifactRepository), checksumAlgorithmFactory));
                if (!Files.isRegularFile(checksumPath, new LinkOption[0])) {
                    LOGGER.debug("Artifact '{}' trusted checksum '{}' not found on path '{}'", new Object[]{artifact, checksumAlgorithmFactory.getName(), checksumPath});
                    continue;
                }
                try {
                    String checksum = this.checksumProcessor.readChecksum(checksumPath);
                    if (checksum == null) continue;
                    checksums.put(checksumAlgorithmFactory.getName(), checksum);
                }
                catch (IOException e) {
                    LOGGER.warn("Could not read artifact '{}' trusted checksum on path '{}'", new Object[]{artifact, checksumPath, e});
                    throw new UncheckedIOException(e);
                }
            }
        }
        return checksums;
    }

    @Override
    protected TrustedChecksumsSource.Writer doGetTrustedArtifactChecksumsWriter(RepositorySystemSession session) {
        return new SparseDirectoryWriter(this.getBasedir(session, LOCAL_REPO_PREFIX_DIR, CONFIG_PROP_BASEDIR, true), this.isOriginAware(session), RepositoryIdHelper.cachedIdToPathSegment((RepositorySystemSession)session));
    }

    private String calculateArtifactPath(boolean originAware, Artifact artifact, String safeRepositoryId, ChecksumAlgorithmFactory checksumAlgorithmFactory) {
        String path = this.localPathComposer.getPathForArtifact(artifact, false) + "." + checksumAlgorithmFactory.getFileExtension();
        if (originAware) {
            path = safeRepositoryId + "/" + path;
        }
        return path;
    }

    private class SparseDirectoryWriter
    implements TrustedChecksumsSource.Writer {
        private final Path basedir;
        private final boolean originAware;
        private final Function<ArtifactRepository, String> idToPathSegmentFunction;

        private SparseDirectoryWriter(Path basedir, boolean originAware, Function<ArtifactRepository, String> idToPathSegmentFunction) {
            this.basedir = basedir;
            this.originAware = originAware;
            this.idToPathSegmentFunction = idToPathSegmentFunction;
        }

        public void addTrustedArtifactChecksums(Artifact artifact, ArtifactRepository artifactRepository, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories, Map<String, String> trustedArtifactChecksums) throws IOException {
            for (ChecksumAlgorithmFactory checksumAlgorithmFactory : checksumAlgorithmFactories) {
                Path checksumPath = this.basedir.resolve(SparseDirectoryTrustedChecksumsSource.this.calculateArtifactPath(this.originAware, artifact, this.idToPathSegmentFunction.apply(artifactRepository), checksumAlgorithmFactory));
                String checksum = Objects.requireNonNull(trustedArtifactChecksums.get(checksumAlgorithmFactory.getName()));
                SparseDirectoryTrustedChecksumsSource.this.checksumProcessor.writeChecksum(checksumPath, checksum);
            }
        }
    }
}

