/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.Stack;

abstract class AbstractDependencyNodeConsumerVisitor
implements DependencyVisitor {
    private static final DependencyFilter ACCEPT_ALL = (d, p) -> true;
    private final Consumer<DependencyNode> nodeConsumer;
    private final DependencyFilter filter;
    private final Stack<DependencyNode> path;
    private final Map<DependencyNode, Object> visitedNodes;

    protected AbstractDependencyNodeConsumerVisitor(Consumer<DependencyNode> nodeConsumer, DependencyFilter filter) {
        this.nodeConsumer = Objects.requireNonNull(nodeConsumer);
        this.filter = filter == null ? ACCEPT_ALL : filter;
        this.path = new Stack();
        this.visitedNodes = new IdentityHashMap<DependencyNode, Object>(512);
    }

    protected boolean setVisited(DependencyNode node) {
        return this.visitedNodes.put(node, Boolean.TRUE) == null;
    }

    public final boolean visitEnter(DependencyNode node) {
        this.path.push(node);
        return this.doVisitEnter(node);
    }

    protected abstract boolean doVisitEnter(DependencyNode var1);

    public final boolean visitLeave(DependencyNode node) {
        this.path.pop();
        return this.doVisitLeave(node);
    }

    protected abstract boolean doVisitLeave(DependencyNode var1);

    protected boolean acceptNode(DependencyNode node) {
        return this.filter.accept(node, this.path);
    }

    protected void consumeNode(DependencyNode node) {
        this.nodeConsumer.accept(node);
    }
}

