/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.metadata.ImmutableCollections;
import org.apache.maven.api.metadata.Snapshot;
import org.apache.maven.api.metadata.SnapshotVersion;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Versioning
implements Serializable {
    final String latest;
    final String release;
    final List<String> versions;
    final String lastUpdated;
    final Snapshot snapshot;
    final List<SnapshotVersion> snapshotVersions;

    protected Versioning(Builder builder) {
        String string = builder.latest != null ? builder.latest : (this.latest = builder.base != null ? builder.base.latest : null);
        String string2 = builder.release != null ? builder.release : (this.release = builder.base != null ? builder.base.release : null);
        this.versions = ImmutableCollections.copy(builder.versions != null ? builder.versions : (builder.base != null ? builder.base.versions : null));
        String string3 = builder.lastUpdated != null ? builder.lastUpdated : (this.lastUpdated = builder.base != null ? builder.base.lastUpdated : null);
        Snapshot snapshot = builder.snapshot != null ? builder.snapshot : (this.snapshot = builder.base != null ? builder.base.snapshot : null);
        this.snapshotVersions = ImmutableCollections.copy(builder.snapshotVersions != null ? builder.snapshotVersions : (builder.base != null ? builder.base.snapshotVersions : null));
    }

    public String getLatest() {
        return this.latest;
    }

    public String getRelease() {
        return this.release;
    }

    @Nonnull
    public List<String> getVersions() {
        return this.versions;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    @Nonnull
    public List<SnapshotVersion> getSnapshotVersions() {
        return this.snapshotVersions;
    }

    @Nonnull
    public Builder with() {
        return Versioning.newBuilder(this);
    }

    @Nonnull
    public Versioning withLatest(String latest) {
        return Versioning.newBuilder(this, true).latest(latest).build();
    }

    @Nonnull
    public Versioning withRelease(String release) {
        return Versioning.newBuilder(this, true).release(release).build();
    }

    @Nonnull
    public Versioning withVersions(Collection<String> versions) {
        return Versioning.newBuilder(this, true).versions(versions).build();
    }

    @Nonnull
    public Versioning withLastUpdated(String lastUpdated) {
        return Versioning.newBuilder(this, true).lastUpdated(lastUpdated).build();
    }

    @Nonnull
    public Versioning withSnapshot(Snapshot snapshot) {
        return Versioning.newBuilder(this, true).snapshot(snapshot).build();
    }

    @Nonnull
    public Versioning withSnapshotVersions(Collection<SnapshotVersion> snapshotVersions) {
        return Versioning.newBuilder(this, true).snapshotVersions(snapshotVersions).build();
    }

    @Nonnull
    public static Versioning newInstance() {
        return Versioning.newInstance(true);
    }

    @Nonnull
    public static Versioning newInstance(boolean withDefaults) {
        return Versioning.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Versioning.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Versioning from) {
        return Versioning.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Versioning from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Versioning base;
        String latest;
        String release;
        Collection<String> versions;
        String lastUpdated;
        Snapshot snapshot;
        Collection<SnapshotVersion> snapshotVersions;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Versioning base, boolean forceCopy) {
            if (forceCopy) {
                this.latest = base.latest;
                this.release = base.release;
                this.versions = base.versions;
                this.lastUpdated = base.lastUpdated;
                this.snapshot = base.snapshot;
                this.snapshotVersions = base.snapshotVersions;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder latest(String latest) {
            this.latest = latest;
            return this;
        }

        @Nonnull
        public Builder release(String release) {
            this.release = release;
            return this;
        }

        @Nonnull
        public Builder versions(Collection<String> versions) {
            this.versions = versions;
            return this;
        }

        @Nonnull
        public Builder lastUpdated(String lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        @Nonnull
        public Builder snapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        @Nonnull
        public Builder snapshotVersions(Collection<SnapshotVersion> snapshotVersions) {
            this.snapshotVersions = snapshotVersions;
            return this;
        }

        @Nonnull
        public Versioning build() {
            if (!(this.base == null || this.latest != null && this.latest != this.base.latest || this.release != null && this.release != this.base.release || this.versions != null && this.versions != this.base.versions || this.lastUpdated != null && this.lastUpdated != this.base.lastUpdated || this.snapshot != null && this.snapshot != this.base.snapshot || this.snapshotVersions != null && this.snapshotVersions != this.base.snapshotVersions)) {
                return this.base;
            }
            return new Versioning(this);
        }
    }
}

