/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class DelegatingExceptionProofRunnable
implements Runnable {
    private static final Log logger = LogFactory.getLog((Class)DelegatingExceptionProofRunnable.class);
    private Runnable delegate;

    public DelegatingExceptionProofRunnable(Runnable delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
    }

    public final Runnable getDelegate() {
        return this.delegate;
    }

    public void run() {
        try {
            this.delegate.run();
        }
        catch (Throwable ex) {
            logger.error((Object)"Unexpected exception thrown from Runnable", ex);
        }
    }
}

