/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.Type3Glyph;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class Type3Font
extends BaseFont {
    private IntHashtable char2byte = new IntHashtable();
    private IntHashtable widths3 = new IntHashtable();
    private HashMap char2glyph = new HashMap<K, V>();
    private PdfWriter writer;
    private float llx = NaNf;
    private float lly;
    private float urx;
    private float ury;
    private PageResources pageResources = new PageResources();
    private boolean colorized;

    /*
     * Unable to fully structure code
     */
    public Type3Font(PdfWriter writer, char[] chars, boolean colorized) {
        super();
        this.writer = writer;
        this.colorized = colorized;
        this.fontType = 5;
        if (chars.length == 0 || chars.length > 256) {
            throw new IllegalArgumentException("char array size must be > 0 and <= 256");
        }
        count = 255;
        hits = new boolean[chars.length];
        k = 0;
        while (k < chars.length) {
            c = chars[k];
            if (c >= ' ' && c < '\u0100') {
                if (this.char2byte.containsKey(c)) {
                    throw new IllegalArgumentException("duplicated char - " + c + ", index " + k);
                }
                this.char2byte.put(c, c);
                hits[k] = true;
            }
            ++k;
        }
        k = 0;
        while (k < hits.length) {
            block7: {
                if (!hits[k]) ** GOTO lbl30
                break block7;
lbl-1000:
                // 1 sources

                {
                    --count;
lbl30:
                    // 2 sources

                    ** while (this.char2byte.containsKey((int)count))
                }
lbl31:
                // 1 sources

                c = chars[k];
                if (this.char2byte.containsKey(c)) {
                    throw new IllegalArgumentException("duplicated char - " + c + ", index " + k);
                }
                this.char2byte.put(c, count--);
            }
            ++k;
        }
    }

    public PdfContentByte defineGlyph(char c, float wx, float llx, float lly, float urx, float ury) {
        if (!this.char2byte.containsKey(c)) {
            throw new IllegalArgumentException("The char " + c + " doesn't belong in this Type3 font");
        }
        Integer ck = new Integer(c);
        Type3Glyph glyph = (Type3Glyph)this.char2glyph.get(ck);
        if (glyph != null) {
            return glyph;
        }
        this.widths3.put(c, (int)wx);
        if (!this.colorized) {
            if (Float.isNaN(this.llx)) {
                this.llx = llx;
                this.lly = lly;
                this.urx = urx;
                this.ury = ury;
            } else {
                this.llx = Math.min(this.llx, llx);
                this.lly = Math.min(this.lly, lly);
                this.urx = Math.max(this.urx, urx);
                this.ury = Math.max(this.ury, ury);
            }
        }
        glyph = new Type3Glyph(this.writer, this.pageResources, wx, llx, lly, urx, ury, this.colorized);
        this.char2glyph.put(ck, glyph);
        return glyph;
    }

    public String[][] getFamilyFontName() {
        return new String[0][];
    }

    public float getFontDescriptor(int key, float fontSize) {
        return 0.0f;
    }

    public String[][] getFullFontName() {
        return new String[0][];
    }

    public int getKerning(char char1, char char2) {
        return 0;
    }

    public String getPostscriptFontName() {
        return "";
    }

    protected int[] getRawCharBBox(int c, String name) {
        return null;
    }

    int getRawWidth(int c, String name) {
        return 0;
    }

    public boolean hasKernPairs() {
        return false;
    }

    public boolean setKerning(char char1, char char2, int kern) {
        return false;
    }

    public void setPostscriptFontName(String name) {
    }

    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
        if (this.writer != writer) {
            throw new IllegalArgumentException("Type3 font used with the wrong PdfWriter");
        }
        if (this.char2byte.size() != this.widths3.size()) {
            throw new DocumentException("Not all the glyphs in the Type3 font are defined");
        }
        IntHashtable inv = new IntHashtable();
        Iterator it = this.char2byte.getEntryIterator();
        while (it.hasNext()) {
            IntHashtable.IntHashtableEntry entry = (IntHashtable.IntHashtableEntry)it.next();
            inv.put(entry.getValue(), entry.getKey());
        }
        int[] invOrd = inv.toOrderedKeys();
        int firstChar = invOrd[0];
        int lastChar = invOrd[invOrd.length - 1];
        int[] widths = new int[lastChar - firstChar + 1];
        int k = 0;
        while (k < widths.length) {
            if (inv.containsKey(k + firstChar)) {
                widths[k] = this.widths3.get(inv.get(k + firstChar));
            }
            ++k;
        }
        PdfArray diffs = new PdfArray();
        PdfDictionary charprocs = new PdfDictionary();
        int last = -1;
        int k2 = 0;
        while (k2 < invOrd.length) {
            int c = invOrd[k2];
            if (c > last) {
                last = c;
                diffs.add(new PdfNumber(last));
            }
            ++last;
            int c2 = inv.get(c);
            String s = GlyphList.unicodeToName(c2);
            if (s == null) {
                s = "a" + c2;
            }
            PdfName n = new PdfName(s);
            diffs.add(n);
            Type3Glyph glyph = (Type3Glyph)this.char2glyph.get(new Integer(c2));
            PdfStream stream = new PdfStream(glyph.toPdf(null));
            stream.flateCompress();
            PdfIndirectReference refp = writer.addToBody(stream).getIndirectReference();
            charprocs.put(n, refp);
            ++k2;
        }
        PdfDictionary font = new PdfDictionary(PdfName.FONT);
        font.put(PdfName.SUBTYPE, PdfName.TYPE3);
        if (this.colorized) {
            font.put(PdfName.FONTBBOX, new PdfRectangle(0.0f, 0.0f, 0.0f, 0.0f));
        } else {
            font.put(PdfName.FONTBBOX, new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        }
        font.put(PdfName.FONTMATRIX, new PdfArray(new float[]{0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f}));
        font.put(PdfName.CHARPROCS, writer.addToBody(charprocs).getIndirectReference());
        PdfDictionary encoding = new PdfDictionary();
        encoding.put(PdfName.DIFFERENCES, diffs);
        font.put(PdfName.ENCODING, writer.addToBody(encoding).getIndirectReference());
        font.put(PdfName.FIRSTCHAR, new PdfNumber(firstChar));
        font.put(PdfName.LASTCHAR, new PdfNumber(lastChar));
        font.put(PdfName.WIDTHS, writer.addToBody(new PdfArray(widths)).getIndirectReference());
        if (this.pageResources.hasResources()) {
            font.put(PdfName.RESOURCES, writer.addToBody(this.pageResources.getResources()).getIndirectReference());
        }
        writer.addToBody((PdfObject)font, ref);
    }

    byte[] convertToBytes(String text) {
        char[] cc = text.toCharArray();
        byte[] b = new byte[cc.length];
        int p = 0;
        int k = 0;
        while (k < cc.length) {
            char c = cc[k];
            if (this.char2byte.containsKey(c)) {
                b[p++] = (byte)this.char2byte.get(c);
            }
            ++k;
        }
        if (b.length == p) {
            return b;
        }
        byte[] b2 = new byte[p];
        System.arraycopy(b, 0, b2, 0, p);
        return b2;
    }

    public int getWidth(char char1) {
        if (!this.widths3.containsKey(char1)) {
            throw new IllegalArgumentException("The char " + char1 + " is not defined in a Type3 font");
        }
        return this.widths3.get(char1);
    }

    public int getWidth(String text) {
        char[] c = text.toCharArray();
        int total = 0;
        int k = 0;
        while (k < c.length) {
            total += this.getWidth(c[k]);
            ++k;
        }
        return total;
    }

    public int[] getCharBBox(char c) {
        return null;
    }

    public boolean charExists(char c) {
        return this.char2byte.containsKey(c);
    }

    public boolean setCharAdvance(char c, int advance) {
        return false;
    }
}

