/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.util;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Typed;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.WindowContext;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.BeanEntryFactory;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.WindowContextManager;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.ConversationKey;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableConversation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public class RequestCache {
    private static ThreadLocal<WindowContext> windowContextCache = new ThreadLocal();
    private static ThreadLocal<WindowContextManager> windowContextManagerCache = new ThreadLocal();
    private static ThreadLocal<BeanEntryFactory> beanEntryFactoryCache = new ThreadLocal();
    private static ThreadLocal<Map<ConversationKey, EditableConversation>> conversationCache = new ThreadLocal();

    protected RequestCache() {
    }

    public static void resetCache() {
        windowContextManagerCache.set(null);
        windowContextManagerCache.remove();
        beanEntryFactoryCache.set(null);
        beanEntryFactoryCache.remove();
        windowContextCache.set(null);
        windowContextCache.remove();
        RequestCache.resetConversationCache();
    }

    public static void resetConversationCache() {
        conversationCache.set(null);
        conversationCache.remove();
    }

    public static WindowContextManager getWindowContextManager() {
        WindowContextManager windowContextManager = windowContextManagerCache.get();
        if (windowContextManager == null) {
            windowContextManager = (WindowContextManager)CodiUtils.getContextualReferenceByClass(WindowContextManager.class, (Annotation[])new Annotation[0]);
            windowContextManagerCache.set(windowContextManager);
        }
        return windowContextManager;
    }

    public static BeanEntryFactory getBeanEntryFactory() {
        BeanEntryFactory beanEntryFactory = beanEntryFactoryCache.get();
        if (beanEntryFactory == null) {
            beanEntryFactory = (BeanEntryFactory)CodiUtils.getContextualReferenceByClass(BeanEntryFactory.class, (Annotation[])new Annotation[0]);
            beanEntryFactoryCache.set(beanEntryFactory);
        }
        return beanEntryFactory;
    }

    public static WindowContext getCurrentWindowContext() {
        return windowContextCache.get();
    }

    public static void setCurrentWindowContext(WindowContext windowContext) {
        windowContextCache.set(windowContext);
    }

    public static EditableConversation getConversation(ConversationKey conversationKey) {
        return RequestCache.getConversationCache().get(conversationKey);
    }

    public static void setConversation(ConversationKey conversationKey, EditableConversation conversation) {
        RequestCache.getConversationCache().put(conversationKey, conversation);
    }

    private static Map<ConversationKey, EditableConversation> getConversationCache() {
        Map<ConversationKey, EditableConversation> conversationMap = conversationCache.get();
        if (conversationMap == null) {
            conversationMap = new HashMap<ConversationKey, EditableConversation>();
            conversationCache.set(conversationMap);
        }
        return conversationMap;
    }
}

