/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import org.apache.myfaces.extensions.cdi.core.api.InvocationOrder;
import org.apache.myfaces.extensions.cdi.core.api.provider.ServiceProviderContext;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.provider.DefaultServiceProviderContext;
import org.apache.myfaces.extensions.cdi.core.impl.provider.SimpleServiceProvider;
import org.apache.myfaces.extensions.cdi.core.impl.provider.spi.EditableServiceProviderContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
@InvocationOrder(value=200)
public class DefaultServiceProvider<T>
extends SimpleServiceProvider<T> {
    private static Map<ClassLoader, Boolean> deploymentFinished = new ConcurrentHashMap<ClassLoader, Boolean>();
    private static Map<Class<?>, List<Class<?>>> serviceCache = new ConcurrentHashMap();

    protected DefaultServiceProvider(Class<T> serviceType, ServiceProviderContext serviceProviderContext) {
        super(serviceType, serviceProviderContext);
        if (serviceProviderContext instanceof DefaultServiceProviderContext) {
            ((DefaultServiceProviderContext)serviceProviderContext).setDeploymentFinished(this.isDeploymentFinished());
        }
    }

    @Override
    protected List<T> loadServiceImplementations() {
        List<Class<?>> result = serviceCache.get(this.serviceType);
        if (result != null) {
            ArrayList<T> foundServices = new ArrayList<T>();
            for (Class<?> serviceClass : result) {
                foundServices.add(this.createInstance(serviceClass));
            }
            return foundServices;
        }
        return super.loadServiceImplementations();
    }

    @Override
    protected List<Class<?>> resolveServiceImplementations() {
        super.resolveServiceImplementations();
        if (this.serviceProviderContext instanceof EditableServiceProviderContext) {
            ((EditableServiceProviderContext)this.serviceProviderContext).preInstallServices(this.foundServiceClasses);
        }
        serviceCache.put(this.serviceType, this.foundServiceClasses);
        return this.foundServiceClasses;
    }

    @Override
    protected boolean isServiceSupported(Class<T> serviceClass) {
        if (this.serviceProviderContext instanceof EditableServiceProviderContext) {
            return !((EditableServiceProviderContext)this.serviceProviderContext).filterService(serviceClass);
        }
        return true;
    }

    @Override
    protected T createInstance(Class<?> serviceClass) {
        Object instance = super.createInstance(serviceClass);
        if (this.serviceProviderContext instanceof EditableServiceProviderContext) {
            return ((EditableServiceProviderContext)this.serviceProviderContext).postConstruct(instance);
        }
        return instance;
    }

    protected void activateInjectionSupport(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        deploymentFinished.put(ClassUtils.getClassLoader(null), Boolean.TRUE);
    }

    private boolean isDeploymentFinished() {
        return Boolean.TRUE.equals(deploymentFinished.get(ClassUtils.getClassLoader(null)));
    }

    protected void reset() {
        this.foundServiceClasses.clear();
        serviceCache.clear();
    }
}

