/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.UISelectBooleanCheckbox;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectBooleanCheckboxRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SelectBooleanCheckboxRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        UIInput input = (UIInput)component;
        if (ComponentUtils.isOutputOnly((UIComponent)input)) {
            return;
        }
        String newValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(input.getClientId(facesContext));
        if (LOG.isDebugEnabled()) {
            LOG.debug("new value = '" + newValue + "'");
        }
        input.setSubmittedValue((Object)("true".equals(newValue) ? "true" : "false"));
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectBooleanCheckbox select = (UISelectBooleanCheckbox)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        String clientId = select.getClientId(facesContext);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)select);
        boolean checked = "true".equals(currentValue);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        boolean disabled = select.isDisabled();
        LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)select);
        writer.startElement("div", (UIComponent)select);
        writer.writeStyleAttribute(new Style(facesContext, (LayoutBase)select));
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.startElement("input", (UIComponent)select);
        writer.writeAttribute("type", "checkbox", false);
        writer.writeAttribute("value", "true", false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("checked", checked);
        writer.writeAttribute("readonly", select.isReadonly());
        writer.writeAttribute("disabled", disabled);
        writer.writeAttribute("required", select.isRequired());
        HtmlRendererUtils.renderFocus(clientId, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
        Integer tabIndex = select.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        HtmlRendererUtils.renderCommandFacet((UIComponent)select, facesContext, writer);
        writer.endElement("input");
        if (label.getLabel() != null) {
            writer.startElement("label", (UIComponent)select);
            writer.writeAttribute("for", clientId, false);
            if (!disabled && label.getAccessKey() != null) {
                writer.writeAttribute("accesskey", Character.toString(label.getAccessKey().charValue()), false);
                AccessKeyLogger.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey(), (String)clientId);
            }
            HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
            writer.endElement("label");
        }
        writer.endElement("div");
    }
}

