/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.internal.component.AbstractUILink;
import org.apache.myfaces.tobago.internal.component.AbstractUILinks;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class LinksRenderer
extends RendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUILinks links = (AbstractUILinks)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.UL);
        writer.writeIdAttribute(links.getClientId(facesContext));
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(links.getMarkup()), false);
        writer.writeClassAttribute(TobagoClass.LINKS, this.getExtraCssItem(), links.getCustomClass());
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof AbstractUILink) {
                child.setRendererType(RendererTypes.LinkInsideLinks.name());
                child.encodeAll(facesContext);
                continue;
            }
            writer.startElement(HtmlElements.LI);
            writer.writeClassAttribute(BootstrapClass.NAV_ITEM);
            child.encodeAll(facesContext);
            writer.endElement(HtmlElements.LI);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.UL);
    }

    protected CssItem getExtraCssItem() {
        return BootstrapClass.NAV;
    }
}

