/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.view.ViewDeclarationLanguage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.util.WebXmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxExceptionHandler
extends ExceptionHandlerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(AjaxExceptionHandler.class);
    private ExceptionHandler wrapped;

    AjaxExceptionHandler(ExceptionHandler exception) {
        this.wrapped = exception;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public void handle() throws FacesException {
        Throwable exception;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && facesContext.getPartialViewContext().isAjaxRequest() && this.getUnhandledExceptionQueuedEvents().iterator().hasNext() && !((exception = ((ExceptionQueuedEvent)this.getUnhandledExceptionQueuedEvents().iterator().next()).getContext().getException()) instanceof AbortProcessingException)) {
            String errorPageLocation = WebXmlUtils.getErrorPageLocation(exception);
            if (!(errorPageLocation == null || facesContext.getCurrentPhaseId() == PhaseId.RENDER_RESPONSE && facesContext.getExternalContext().isResponseCommitted())) {
                try {
                    HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
                    HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
                    request.setAttribute("javax.servlet.error.exception", (Object)exception);
                    request.setAttribute("javax.servlet.error.exception_type", exception.getClass());
                    request.setAttribute("javax.servlet.error.message", (Object)exception.getMessage());
                    request.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
                    request.setAttribute("javax.servlet.error.status_code", (Object)500);
                    response.setStatus(500);
                    this.renderErrorPage(facesContext, errorPageLocation);
                    this.cleanupExceptionQueuedEvents();
                }
                catch (IOException e) {
                    throw new FacesException((Throwable)e);
                }
            } else {
                LOG.debug("Can't return an error page. errorPageLocation='{}'", (Object)errorPageLocation);
            }
        }
        this.getWrapped().handle();
    }

    private void renderErrorPage(FacesContext facesContext, String errorPageLocation) throws IOException {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        UIViewRoot viewRoot = viewHandler.createView(facesContext, errorPageLocation);
        facesContext.setViewRoot(viewRoot);
        facesContext.getPartialViewContext().setRenderAll(true);
        ViewDeclarationLanguage viewDeclarationLanguage = viewHandler.getViewDeclarationLanguage(facesContext, errorPageLocation);
        viewDeclarationLanguage.buildView(facesContext, viewRoot);
        facesContext.getApplication().publishEvent(facesContext, PreRenderViewEvent.class, (Object)viewRoot);
        viewDeclarationLanguage.renderView(facesContext, viewRoot);
        facesContext.responseComplete();
    }

    private void cleanupExceptionQueuedEvents() {
        Iterator exceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents().iterator();
        while (exceptionQueuedEvents.hasNext()) {
            exceptionQueuedEvents.next();
            exceptionQueuedEvents.remove();
        }
    }
}

