<?xml version="1.0" encoding="UTF-8"?>
<!--
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">

    <parent>
        <groupId>org.apache.myfaces.core</groupId>
        <artifactId>myfaces-core-project</artifactId>
        <version>2.1.18</version>
        <relativePath>../parent/pom.xml</relativePath>
    </parent>

    <modelVersion>4.0.0</modelVersion>

    <artifactId>myfaces-bundle</artifactId>
    <name>Apache MyFaces JSF-2.1 Core OSGi Bundle</name>
    <packaging>bundle</packaging>

    <scm>
        <connection>scm:svn:http://svn.apache.org/repos/asf/myfaces/core/tags/myfaces-core-module-2.1.18/bundle</connection>
        <developerConnection>scm:svn:https://svn.apache.org/repos/asf/myfaces/core/tags/myfaces-core-module-2.1.18/bundle</developerConnection>
        <url>http://svn.apache.org/repos/asf/myfaces/core/tags/myfaces-core-module-2.1.18/bundle</url>
    </scm>
    
    <build>
        <plugins>
            <plugin>
                <groupId>org.apache.felix</groupId>
                <artifactId>maven-bundle-plugin</artifactId>
                <version>2.5.3</version>
                <extensions>true</extensions>
                <configuration>
                    <instructions>
                        <Bundle-SymbolicName>org.apache.myfaces.core.bundle</Bundle-SymbolicName>
                        <Build-Jdk>${java.version}</Build-Jdk>
                        <Implementation-Title>${project.name}</Implementation-Title>
                        <Implementation-Version>${project.version}</Implementation-Version>
                        <Implementation-Vendor>The Apache Software Foundation</Implementation-Vendor>
                        <Implementation-Vendor-Id>${project.groupId}</Implementation-Vendor-Id>
                        <Export-Package>
                            javax.faces.*;version="${project.version}",
                            org.apache.myfaces.config.annotation;version="${project.version}",
                            org.apache.myfaces.shared_impl.webapp.webxml;version="${project.version}",
                            org.apache.myfaces.shared.taglib;version="${project.version}",
                            org.apache.myfaces.shared.taglib.core;version="${project.version}",
                            org.apache.myfaces.spi;version="${project.version}",
                            org.apache.myfaces.webapp;version="${project.version}",
                            org.apache.myfaces.taglib.*;version="${project.version}",
                            org.apache.myfaces.ee6;version="${project.version}",
                            org.apache.myfaces.config.element;version="${project.version}",
                            org.apache.myfaces.config.impl.digester.elements;version="${project.version}"
                        </Export-Package>
                        <Import-Package>
                            !org.apache.myfaces.*,
                            com.google.inject;version="[1.0.0, 2.0.0)";resolution:=optional,
                            javax.annotation,
                            javax.crypto,
                            javax.crypto.spec,
                            javax.ejb;resolution:=optional,
                            javax.el;version="[1.0.0, 3.0.0)",
                            javax.naming,
                            javax.persistence;version="[1.0.0, 2.1)";resolution:=optional,
                            javax.portlet;version="[1.0.0, 2.1)";resolution:=optional,
                            javax.servlet;version="[2.5.0, 3.1)",
                            javax.servlet.http;version="[2.5.0, 3.1)",
                            javax.servlet.jsp;version="[2.1.0, 3.1)",
                            javax.servlet.jsp.jstl.core;version="[1.1.2, 2.0.0)",
                            javax.servlet.jsp.tagext;version="[2.1.0, 3.1)",
                            javax.servlet.annotation;version="[2.5.0, 4.0)";resolution:=optional,
                            javax.validation.*;version="[1.0.0, 2.0.0)";resolution:=optional,
                            javax.xml.parsers,
                            org.apache;resolution:=optional,
                            org.apache.commons.beanutils;version="[1.8.3, 2.0.0)",
                            org.apache.commons.codec.binary;version="[1.3.0, 2.0.0)",
                            org.apache.commons.collections.map;version="[3.2.0, 4.0.0)",
                            org.apache.commons.digester;version="[1.8.0, 2.0.0)",
                            org.apache.commons.logging;version="[1.1.1, 2.0.0)",
                            org.w3c.dom,
                            org.xml.sax,
                            org.xml.sax.helpers,
                            org.apache.jasper.compiler;resolution:=optional,
                            org.apache.jasper.el;resolution:=optional,
                            org.apache.el;resolution:=optional,
                            org.apache.tomcat;resolution:=optional,
                            *
                        </Import-Package>
                        <Embed-Dependency>*;type=!pom;inline=true</Embed-Dependency>
                    </instructions>
                </configuration>
            </plugin>
        </plugins>
    </build>

    
    <dependencies>
        <!-- include myfaces-api and myfaces-impl in the bundle -->
        <dependency>
            <groupId>org.apache.myfaces.core</groupId>
            <artifactId>myfaces-api</artifactId>
            <scope>provided</scope>
        </dependency>
        <dependency>
            <groupId>org.apache.myfaces.core</groupId>
            <artifactId>myfaces-impl</artifactId>
            <scope>provided</scope>
        </dependency>
    </dependencies>
    
</project>
