/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.api.support.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jpt30.lang.model.element.AnnotationMirror;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationScanner;

public class AnnotationHelper {
    private CompilationInfo info;
    private AnnotationModelHelper helper;

    public AnnotationHelper(CompilationInfo info) {
        this.info = info;
    }

    public AnnotationHelper(AnnotationModelHelper helper) {
        this.helper = helper;
    }

    public TypeMirror resolveType(String typeName) {
        TypeElement type = this.getCompilationInfo().getElements().getTypeElement(typeName);
        if (type != null) {
            return type.asType();
        }
        return null;
    }

    public AnnotationScanner getAnnotationScanner() {
        return new AnnotationScanner(this);
    }

    public boolean isSameRawType(TypeMirror type1, String type2ElementName) {
        TypeElement type2Element = this.getCompilationInfo().getElements().getTypeElement(type2ElementName);
        if (type2Element != null) {
            Types types = this.getCompilationInfo().getTypes();
            TypeMirror type2 = types.erasure(type2Element.asType());
            return types.isSameType(types.erasure(type1), type2);
        }
        return false;
    }

    public List<? extends TypeElement> getSuperclasses(TypeElement type) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        TypeElement currentType = type;
        while ((currentType = this.getSuperclass(currentType)) != null) {
            result.add(currentType);
        }
        return Collections.unmodifiableList(result);
    }

    public TypeElement getSuperclass(TypeElement type) {
        TypeElement superclass;
        Element element;
        TypeMirror supertype = type.getSuperclass();
        if (TypeKind.DECLARED == supertype.getKind() && ElementKind.CLASS == (element = ((DeclaredType)supertype).asElement()).getKind() && !(superclass = (TypeElement)element).getQualifiedName().contentEquals(Object.class.getCanonicalName())) {
            return superclass;
        }
        return null;
    }

    public boolean hasAnnotation(List<? extends AnnotationMirror> annotations, String annotationTypeName) {
        for (AnnotationMirror annotationMirror : annotations) {
            String typeName = this.getAnnotationTypeName(annotationMirror.getAnnotationType());
            if (!annotationTypeName.equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyAnnotation(List<? extends AnnotationMirror> annotations, Set<String> annotationTypeNames) {
        for (AnnotationMirror annotationMirror : annotations) {
            String annotationTypeName = this.getAnnotationTypeName(annotationMirror.getAnnotationType());
            if (annotationTypeName == null || !annotationTypeNames.contains(annotationTypeName)) continue;
            return true;
        }
        return false;
    }

    public Map<String, ? extends AnnotationMirror> getAnnotationsByType(List<? extends AnnotationMirror> annotations) {
        HashMap<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
        for (AnnotationMirror annotationMirror : annotations) {
            String typeName = this.getAnnotationTypeName(annotationMirror.getAnnotationType());
            if (typeName == null) continue;
            result.put(typeName, annotationMirror);
        }
        return Collections.unmodifiableMap(result);
    }

    public String getAnnotationTypeName(DeclaredType typeMirror) {
        if (TypeKind.DECLARED != typeMirror.getKind()) {
            return null;
        }
        Element element = typeMirror.asElement();
        if (ElementKind.ANNOTATION_TYPE != element.getKind()) {
            return null;
        }
        return ((TypeElement)element).getQualifiedName().toString();
    }

    public CompilationInfo getCompilationInfo() {
        if (this.helper == null) {
            return this.info;
        }
        return this.helper.getCompilationController();
    }
}

