/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.ProxyClassLoader;

final class ProxyClassParents {
    private final Set<ProxyClassLoader> parentSet;
    private final boolean transitive;
    private final ClassLoader systemCL;

    private ProxyClassParents(ClassLoader systemCL, Set<ProxyClassLoader> parentSet, boolean transitive) {
        this.systemCL = systemCL;
        this.parentSet = parentSet;
        this.transitive = transitive;
    }

    static ProxyClassParents coalesceParents(ClassLoader root, ClassLoader[] loaders, ClassLoader systemCL, boolean transitive) throws IllegalArgumentException {
        ClassLoader[] arr = new ClassLoader[]{systemCL};
        Set<ProxyClassLoader> parents = ProxyClassParents.coalesceAppend(root, Collections.emptySet(), loaders, arr);
        return new ProxyClassParents(arr[0], parents, transitive);
    }

    private static Set<ProxyClassLoader> coalesceAppend(ClassLoader root, Set<ProxyClassLoader> existing, ClassLoader[] appended, ClassLoader[] systemCL) throws IllegalArgumentException {
        int likelySize = existing.size() + appended.length;
        LinkedHashSet<ClassLoader> uniq = new LinkedHashSet<ClassLoader>(likelySize);
        uniq.addAll(existing);
        if (uniq.containsAll(Arrays.asList(appended))) {
            return existing;
        }
        for (ClassLoader l : appended) {
            ProxyClassParents.addRec(root, uniq, l);
        }
        boolean head = true;
        LinkedHashSet<ProxyClassLoader> pcls = new LinkedHashSet<ProxyClassLoader>(uniq.size());
        for (ClassLoader l : uniq) {
            if (head) {
                if (l instanceof ProxyClassLoader) {
                    head = false;
                    pcls.add((ProxyClassLoader)l);
                    continue;
                }
                if (ProxyClassParents.isParentOf(systemCL[0], l)) {
                    systemCL[0] = l;
                    continue;
                }
                throw new IllegalArgumentException("Bad ClassLoader ordering: " + Arrays.asList(appended));
            }
            if (l instanceof ProxyClassLoader) {
                pcls.add((ProxyClassLoader)l);
                continue;
            }
            throw new IllegalArgumentException("Bad ClassLoader ordering: " + Arrays.asList(appended));
        }
        return pcls;
    }

    private static void addRec(ClassLoader root, Set<ClassLoader> resultingUnique, ClassLoader loader) throws IllegalArgumentException {
        if (loader == root) {
            throw new IllegalArgumentException("cycle in parents");
        }
        if (resultingUnique.contains(loader)) {
            return;
        }
        if (loader instanceof ProxyClassLoader && ((ProxyClassLoader)loader).parents.transitive) {
            for (ProxyClassLoader lpar : ((ProxyClassLoader)loader).parents.loaders()) {
                ProxyClassParents.addRec(root, resultingUnique, lpar);
            }
        }
        resultingUnique.add(loader);
    }

    boolean contains(ProxyClassLoader pcl) {
        return this.parentSet.contains(pcl);
    }

    Iterable<ProxyClassLoader> loaders() {
        boolean assertOn = false;
        if (!$assertionsDisabled) {
            assertOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertOn ? Collections.unmodifiableSet(this.parentSet) : this.parentSet;
    }

    int size() {
        return this.parentSet.size();
    }

    ProxyClassParents append(ClassLoader root, ClassLoader[] nueparents) {
        ClassLoader[] arr = new ClassLoader[]{this.systemCL};
        Set<ProxyClassLoader> parents = ProxyClassParents.coalesceAppend(root, this.parentSet, nueparents, arr);
        return new ProxyClassParents(arr[0], parents, this.transitive);
    }

    private static boolean isParentOf(ClassLoader parent, ClassLoader child) {
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    ClassLoader systemCL() {
        return this.systemCL;
    }

    boolean isTransitive() {
        return this.transitive;
    }

    ProxyClassParents changeSystemClassLoader(ClassLoader s) {
        return new ProxyClassParents(s, this.parentSet, this.transitive);
    }
}

