/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.caret;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.CaretItem;
import org.netbeans.api.editor.caret.CaretMoveContext;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.api.editor.caret.MoveCaretsOrigin;
import org.netbeans.api.editor.document.ComplexPositions;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.spi.editor.caret.CaretMoveHandler;

final class CaretTransaction {
    private static final Logger LOG = Logger.getLogger(CaretTransaction.class.getName());
    private final EditorCaret editorCaret;
    private final JTextComponent component;
    private final Document doc;
    private final GapList<CaretItem> origCaretItems;
    private int modIndex;
    private int modEndIndex;
    private CaretItem[] addCaretItems;
    private int affectedStartIndex = Integer.MAX_VALUE;
    private int affectedEndIndex;
    private int affectedStartOffset = Integer.MAX_VALUE;
    private int affectedEndOffset;
    private boolean addOrRemove;
    private boolean anyDotChanged;
    private boolean anyMarkChanged;
    private boolean magicPosChanged;
    private boolean scrollToLastCaret;
    private GapList<CaretItem> replaceItems;
    private GapList<CaretItem> replaceSortedItems;
    private GapList<CaretItem> extraRemovedItems;
    private GapList<CaretItem> allRemovedItems;
    private List<Position> expandFoldPositions;
    private int[] indexes;
    private int indexesLength;
    private int indexHintEnd;
    private boolean fullResort;
    private final MoveCaretsOrigin origin;

    CaretTransaction(EditorCaret caret, JTextComponent component, Document doc, MoveCaretsOrigin origin) {
        this.editorCaret = caret;
        this.component = component;
        this.doc = doc;
        this.origCaretItems = this.editorCaret.getCaretItems();
        this.origin = origin;
    }

    @NonNull
    EditorCaret getCaret() {
        return this.editorCaret;
    }

    @NonNull
    JTextComponent getComponent() {
        return this.component;
    }

    @NonNull
    Document getDocument() {
        return this.doc;
    }

    boolean isDotOrStructuralChange() {
        return this.addOrRemove || this.anyDotChanged || this.anyMarkChanged;
    }

    boolean isAnyDotChanged() {
        return this.anyDotChanged;
    }

    boolean isAnyMarkChanged() {
        return this.anyMarkChanged;
    }

    boolean isMagicPosChange() {
        return this.magicPosChanged;
    }

    boolean moveDot(@NonNull CaretItem caret, @NonNull Position dotPos, @NonNull Position.Bias dotBias) {
        Position markPos = caret.getMarkPosition();
        Position.Bias markBias = caret.getMarkBias();
        if (markPos == null) {
            markPos = caret.getDotPosition();
            markBias = caret.getDotBias();
        }
        return this.setDotAndMark(caret, dotPos, dotBias, markPos, markBias);
    }

    boolean setDotAndMark(@NonNull CaretItem caretItem, @NonNull Position dotPos, @NonNull Position.Bias dotBias, @NonNull Position markPos, @NonNull Position.Bias markBias) {
        assert (dotPos != null) : "dotPos must not be null";
        assert (markPos != null) : "markPos must not be null";
        int index = this.findCaretItemIndex(this.origCaretItems, caretItem);
        if (index != -1) {
            Position origDotPos = caretItem.getDotPosition();
            Position origMarkPos = caretItem.getMarkPosition();
            boolean dotChanged = origDotPos == null || ComplexPositions.compare(dotPos, origDotPos) != 0 || dotBias != caretItem.getDotBias();
            boolean markChanged = origMarkPos == null || ComplexPositions.compare(markPos, origMarkPos) != 0 || markBias != caretItem.getMarkBias();
            this.scrollToLastCaret = true;
            if (dotChanged || markChanged) {
                this.editorCaret.ensureValidInfo(caretItem);
                if (this.expandFoldPositions == null) {
                    this.expandFoldPositions = new ArrayList<Position>(2);
                }
                if (dotChanged) {
                    caretItem.setDotPos(dotPos);
                    this.expandFoldPositions.add(dotPos);
                    this.anyDotChanged = true;
                }
                if (markChanged) {
                    caretItem.setMarkPos(markPos);
                    this.expandFoldPositions.add(markPos);
                    this.anyMarkChanged = true;
                }
                this.updateAffectedIndexes(index, index + 1);
                caretItem.markUpdateCaretBounds();
                caretItem.markInfoObsolete();
                return true;
            }
            return false;
        }
        return false;
    }

    boolean setMagicCaretPosition(@NonNull CaretItem caretItem, Point p) {
        int index = this.findCaretItemIndex(this.origCaretItems, caretItem);
        if (index != -1) {
            caretItem.setMagicCaretPosition(p);
            this.magicPosChanged = true;
            caretItem.markInfoObsolete();
            this.updateAffectedIndexes(index, index + 1);
            return true;
        }
        return false;
    }

    void documentInsertAtZeroOffset(int insertEndOffset) {
        Position insertEndPos = null;
        for (CaretItem caretItem : this.editorCaret.getSortedCaretItems()) {
            boolean modifyMark;
            Position dotPos = caretItem.getDotPosition();
            Position.Bias dotBias = caretItem.getDotBias();
            boolean modifyDot = dotPos == null || dotPos.getOffset() == 0;
            Position markPos = caretItem.getMarkPosition();
            Position.Bias markBias = caretItem.getMarkBias();
            boolean bl = modifyMark = markPos == null || markPos.getOffset() == 0;
            if (!modifyDot && !modifyMark) continue;
            if (insertEndPos == null) {
                try {
                    insertEndPos = this.doc.createPosition(insertEndOffset);
                }
                catch (BadLocationException ex) {
                    return;
                }
            }
            if (modifyDot) {
                dotPos = insertEndPos;
            }
            if (modifyMark) {
                markPos = insertEndPos;
            }
            this.setDotAndMark(caretItem, dotPos, dotBias, markPos, markBias);
        }
        if (insertEndPos != null) {
            this.updateAffectedOffsets(0, insertEndOffset);
            this.fullResort = true;
        }
    }

    void documentRemove(int offset) {
        this.fullResort = true;
    }

    void handleCaretRemove(@NonNull CaretInfo caret) {
    }

    GapList<CaretItem> getReplaceItems() {
        return this.replaceItems;
    }

    GapList<CaretItem> getSortedCaretItems() {
        return this.replaceSortedItems;
    }

    public boolean isScrollToLastCaret() {
        return this.scrollToLastCaret;
    }

    List<CaretInfo> getOriginalCarets() {
        return this.editorCaret.getCarets();
    }

    List<CaretInfo> getOriginalSortedCarets() {
        return this.editorCaret.getSortedCarets();
    }

    MoveCaretsOrigin getOrigin() {
        return this.origin;
    }

    void replaceCarets(RemoveType removeType, int offset, CaretItem[] addCaretItems) {
        int size = this.origCaretItems.size();
        switch (removeType) {
            case NO_REMOVE: {
                break;
            }
            case TOGGLE_CARET: {
                if (null == addCaretItems || addCaretItems.length != 1 || this.origCaretItems.size() < 2) break;
                CaretItem caretToAdd = addCaretItems[0];
                int caretFoundAtIndex = -1;
                for (int i = 0; i < this.origCaretItems.size(); ++i) {
                    CaretItem origCaretItem = this.origCaretItems.get(i);
                    if (origCaretItem.getDot() != caretToAdd.getDot() || origCaretItem.getMark() != caretToAdd.getMark()) continue;
                    caretFoundAtIndex = i;
                    break;
                }
                if (caretFoundAtIndex == -1) break;
                this.modIndex = caretFoundAtIndex;
                this.modEndIndex = Math.min(caretFoundAtIndex + 1, size);
                this.addOrRemove = true;
                addCaretItems = null;
                break;
            }
            case REMOVE_LAST_CARET: {
                if (size <= 1) break;
                this.modIndex = size - 1;
                this.modEndIndex = size;
                this.addOrRemove = true;
                break;
            }
            case RETAIN_LAST_CARET: {
                if (size <= 1) break;
                this.modEndIndex = size - 1;
                this.addOrRemove = true;
                break;
            }
            case REMOVE_ALL_CARETS: {
                if (size <= 0) break;
                this.modEndIndex = size;
                this.addOrRemove = true;
                break;
            }
            case DOCUMENT_REMOVE: {
                break;
            }
            case DOCUMENT_INSERT_ZERO_OFFSET: {
                this.documentInsertAtZeroOffset(offset);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled removeType=" + (Object)((Object)removeType)));
            }
        }
        if (addCaretItems != null) {
            this.addCaretItems = addCaretItems;
            this.addOrRemove = true;
        }
        if (this.addOrRemove) {
            this.scrollToLastCaret = true;
        }
    }

    void runCaretMoveHandler(CaretMoveHandler handler) {
        CaretMoveContext context = new CaretMoveContext(this);
        handler.moveCarets(context);
    }

    void removeOverlappingRegions() {
        this.removeOverlappingRegions(0, Integer.MAX_VALUE);
    }

    void removeOverlappingRegions(int removeOffset) {
        this.removeOverlappingRegions(0, removeOffset);
    }

    void removeOverlappingRegions(int startIndex, int stopOffset) {
        if (this.addOrRemove) {
            this.initReplaceItems();
        } else if (this.anyDotChanged || this.anyMarkChanged) {
            this.initReplaceItems();
        }
        GapList<CaretItem> origSortedItems = this.replaceSortedItems != null ? this.replaceSortedItems : this.editorCaret.getSortedCaretItems();
        int origSortedItemsSize = origSortedItems.size();
        GapList nonOverlappingItems = null;
        int copyStartIndex = 0;
        int i = startIndex - 1;
        boolean itemsRemoved = false;
        CaretItemInfo lastInfo = new CaretItemInfo();
        if (i >= 0) {
            lastInfo.update(origSortedItems.get(i));
        }
        CaretItemInfo itemInfo = new CaretItemInfo();
        while (++i < origSortedItemsSize) {
            itemInfo.update(origSortedItems.get(i));
            if (lastInfo.caretItem != null) {
                if (itemInfo.overlapsAtStart(lastInfo)) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("CaretTransaction.removeOverlappingRegions(): [" + i + "]: overlap at start of itemInfo=" + itemInfo + "\n  with lastInfo=" + lastInfo + "\n");
                    }
                    if (nonOverlappingItems == null) {
                        nonOverlappingItems = new GapList(origSortedItemsSize - 1);
                    }
                    itemsRemoved = true;
                    if (!lastInfo.dotAtStart) {
                        if (lastInfo.startsBelow(itemInfo)) {
                            this.updateAffectedOffsets(lastInfo.startOffset, itemInfo.startOffset);
                            this.setDotAndMark(itemInfo.caretItem, lastInfo.startPos, lastInfo.startBias, itemInfo.endPos, itemInfo.endBias);
                        }
                        lastInfo.caretItem.markRemovedInTransaction();
                        origSortedItems.copyElements(copyStartIndex, i - 1, nonOverlappingItems);
                        copyStartIndex = i;
                    } else {
                        if (itemInfo.endsAbove(lastInfo)) {
                            this.updateAffectedOffsets(lastInfo.endOffset, itemInfo.endOffset);
                            this.setDotAndMark(lastInfo.caretItem, lastInfo.startPos, lastInfo.startBias, itemInfo.endPos, itemInfo.endBias);
                        }
                        itemInfo.caretItem.markRemovedInTransaction();
                        origSortedItems.copyElements(copyStartIndex, i, nonOverlappingItems);
                        copyStartIndex = i + 1;
                    }
                } else if (itemInfo.dotsOverlap(lastInfo)) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("CaretTransaction.removeOverlappingRegions(): [" + i + "]: dots overlap: itemInfo=" + itemInfo + "\n  with lastInfo=" + lastInfo + "\n");
                    }
                    if (nonOverlappingItems == null) {
                        nonOverlappingItems = new GapList(origSortedItemsSize - 1);
                    }
                    itemsRemoved = true;
                    if (itemInfo.selection) {
                        if (itemInfo.dotAtStart) {
                            this.setDotAndMark(lastInfo.caretItem, itemInfo.endPos, itemInfo.endBias, lastInfo.startPos, lastInfo.startBias);
                            itemInfo.caretItem.markRemovedInTransaction();
                            origSortedItems.copyElements(copyStartIndex, i, nonOverlappingItems);
                            copyStartIndex = i + 1;
                        } else {
                            this.setDotAndMark(itemInfo.caretItem, lastInfo.endPos, lastInfo.endBias, itemInfo.startPos, itemInfo.startBias);
                            lastInfo.caretItem.markRemovedInTransaction();
                            origSortedItems.copyElements(copyStartIndex, i - 1, nonOverlappingItems);
                            copyStartIndex = i;
                        }
                    } else {
                        itemInfo.caretItem.markRemovedInTransaction();
                        origSortedItems.copyElements(copyStartIndex, i, nonOverlappingItems);
                        copyStartIndex = i + 1;
                    }
                }
            }
            CaretItemInfo tmp = lastInfo;
            lastInfo = itemInfo;
            itemInfo = tmp;
            if (lastInfo.endOffset <= stopOffset) continue;
            break;
        }
        if (itemsRemoved) {
            if (copyStartIndex < origSortedItemsSize) {
                origSortedItems.copyElements(copyStartIndex, origSortedItemsSize, nonOverlappingItems);
            }
            GapList<CaretItem> origItems = this.resultItems();
            int origItemsSize = origItems.size();
            this.replaceItems = new GapList(origItemsSize);
            for (i = 0; i < origItemsSize; ++i) {
                CaretItem caretItem = origItems.get(i);
                if (caretItem.getAndClearRemovedInTransaction()) {
                    if (this.extraRemovedItems == null) {
                        this.extraRemovedItems = new GapList();
                    }
                    this.extraRemovedItems.add(caretItem);
                    continue;
                }
                this.replaceItems.add(caretItem);
            }
            this.replaceSortedItems = nonOverlappingItems;
        }
    }

    GapList<CaretItem> allRemovedItems() {
        int extraRemovedSize;
        int removeSize = this.modEndIndex - this.modIndex;
        int n = extraRemovedSize = this.extraRemovedItems != null ? this.extraRemovedItems.size() : 0;
        if (removeSize + extraRemovedSize > 0 && this.allRemovedItems == null) {
            this.allRemovedItems = new GapList(removeSize + extraRemovedSize);
            if (removeSize > 0) {
                this.allRemovedItems.addAll(this.origCaretItems, this.modIndex, removeSize);
            }
            if (extraRemovedSize > 0) {
                this.allRemovedItems.addAll(this.extraRemovedItems);
            }
        }
        return this.allRemovedItems;
    }

    List<Position> expandFoldPositions() {
        return this.expandFoldPositions;
    }

    private GapList<CaretItem> resultItems() {
        return this.replaceItems != null ? this.replaceItems : this.origCaretItems;
    }

    private void initReplaceItems() {
        boolean updateIndividual;
        assert (this.replaceItems == null) : "replaceItems already inited to " + this.replaceItems;
        int size = this.origCaretItems.size();
        int removeSize = this.modEndIndex - this.modIndex;
        int addSize = this.addCaretItems != null ? this.addCaretItems.length : 0;
        int newSize = size - removeSize + addSize;
        this.replaceItems = new GapList(newSize);
        if (removeSize > 0) {
            this.replaceItems.addAll(this.origCaretItems, 0, this.modIndex);
            this.replaceItems.addAll(this.origCaretItems, this.modEndIndex, size - this.modEndIndex);
        } else {
            this.replaceItems.addAll(this.origCaretItems);
        }
        if (this.addCaretItems != null) {
            this.replaceItems.addArray(this.replaceItems.size(), this.addCaretItems);
        }
        assert (this.replaceItems.size() == newSize);
        boolean bl = updateIndividual = removeSize + addSize < newSize >> 2;
        if (!this.fullResort) {
            // empty if block
        }
        this.replaceSortedItems = this.replaceItems.copy();
        if (newSize > 1) {
            Collections.sort(this.replaceSortedItems);
        }
    }

    private void resetIndexes() {
        this.indexesLength = 0;
    }

    private void addToIndexes(int index) {
        if (this.indexes == null) {
            this.indexes = new int[8];
        } else if (this.indexesLength == this.indexes.length) {
            int[] orig = this.indexes;
            this.indexes = new int[this.indexesLength << 1];
            System.arraycopy(orig, 0, this.indexes, 0, this.indexesLength);
        }
        this.indexes[this.indexesLength++] = index;
    }

    private int findCaretItemIndex(GapList<CaretItem> caretItems, CaretItem caretItem) {
        int size;
        int i = caretItem.getTransactionIndexHint();
        if (i >= (size = caretItems.size()) || caretItems.get(i) != caretItem) {
            while (this.indexHintEnd < size) {
                CaretItem c = caretItems.get(this.indexHintEnd);
                c.setTransactionIndexHint(this.indexHintEnd++);
                if (c != caretItem) continue;
                return this.indexHintEnd - 1;
            }
            return -1;
        }
        return i;
    }

    private void updateAffectedIndexes(int startIndex, int endIndex) {
        if (this.affectedStartIndex == Integer.MAX_VALUE) {
            this.affectedStartIndex = startIndex;
            this.affectedEndIndex = endIndex;
        } else {
            this.affectedStartIndex = Math.min(this.affectedStartIndex, startIndex);
            this.affectedEndIndex = Math.max(this.affectedEndIndex, endIndex);
        }
    }

    private void updateAffectedOffsets(int startOffset, int endOffset) {
        if (this.affectedStartOffset == Integer.MAX_VALUE) {
            this.affectedStartOffset = startOffset;
            this.affectedEndOffset = endOffset;
        } else {
            if (startOffset < this.affectedStartOffset) {
                this.affectedStartOffset = startOffset;
            }
            if (endOffset > this.affectedEndOffset) {
                this.affectedEndOffset = endOffset;
            }
        }
    }

    static CaretItem[] asCaretItems(EditorCaret caret, @NonNull List<Position> dotAndSelectionStartPosPairs, List<Position.Bias> dotAndMarkBiases) {
        int size = dotAndSelectionStartPosPairs.size();
        if ((size & 1) != 0) {
            throw new IllegalStateException("Passed list has size=" + size + " which is not an even number.");
        }
        CaretItem[] addedCarets = new CaretItem[size >> 1];
        int listIndex = 0;
        for (int j = 0; j < addedCarets.length; ++j) {
            CaretItem caretItem;
            Position.Bias dotBias = dotAndMarkBiases != null ? dotAndMarkBiases.get(listIndex) : Position.Bias.Forward;
            Position dotPos = dotAndSelectionStartPosPairs.get(listIndex++);
            Position.Bias markBias = dotAndMarkBiases != null ? dotAndMarkBiases.get(listIndex) : Position.Bias.Forward;
            Position selectionStartPos = dotAndSelectionStartPosPairs.get(listIndex++);
            addedCarets[j] = caretItem = new CaretItem(caret, dotPos, dotBias, selectionStartPos, markBias);
        }
        return addedCarets;
    }

    private static final class CaretItemInfo {
        CaretItem caretItem;
        Position startPos;
        Position.Bias startBias;
        Position endPos;
        Position.Bias endBias;
        int dotOffset;
        int dotShift;
        int startOffset;
        int startShift;
        int endOffset;
        int endShift;
        boolean dotAtStart;
        boolean selection;

        private CaretItemInfo() {
        }

        void update(CaretItem caret) {
            this.caretItem = caret;
            Position dotPos = caret.getDotPosition();
            if (dotPos != null) {
                this.dotOffset = dotPos.getOffset();
                this.dotShift = ComplexPositions.getSplitOffset(dotPos);
                Position markPos = caret.getMarkPosition();
                if (markPos != null && markPos != dotPos) {
                    int markOffset = markPos.getOffset();
                    int markShift = ComplexPositions.getSplitOffset(markPos);
                    if (markOffset < this.dotOffset || markOffset == this.dotOffset && markShift < this.dotShift) {
                        this.startPos = markPos;
                        this.startBias = caret.getMarkBias();
                        this.endPos = dotPos;
                        this.endBias = caret.getDotBias();
                        this.startOffset = markOffset;
                        this.startShift = markShift;
                        this.endOffset = this.dotOffset;
                        this.endShift = this.dotShift;
                        this.dotAtStart = false;
                        this.selection = true;
                    } else if (markOffset == this.dotOffset && markShift == this.dotShift) {
                        this.startPos = markPos;
                        this.startBias = caret.getMarkBias();
                        this.endPos = dotPos;
                        this.endBias = caret.getDotBias();
                        this.startOffset = markOffset;
                        this.startShift = markShift;
                        this.endOffset = this.dotOffset;
                        this.endShift = this.dotShift;
                        this.dotAtStart = false;
                        this.selection = false;
                    } else {
                        this.startPos = dotPos;
                        this.startBias = caret.getDotBias();
                        this.endPos = markPos;
                        this.endBias = caret.getMarkBias();
                        this.startOffset = this.dotOffset;
                        this.startShift = this.dotShift;
                        this.endOffset = markOffset;
                        this.endShift = markShift;
                        this.dotAtStart = true;
                        this.selection = true;
                    }
                } else {
                    this.startPos = this.endPos = dotPos;
                    this.startBias = this.endBias = caret.getDotBias();
                    this.startOffset = this.endOffset = this.dotOffset;
                    this.startShift = this.startShift = this.dotShift;
                    this.dotAtStart = false;
                    this.selection = false;
                }
            } else {
                this.clear();
            }
        }

        void clear() {
            this.caretItem = null;
            this.dotShift = 0;
            this.dotOffset = 0;
            this.endPos = null;
            this.startPos = null;
            this.endOffset = 0;
            this.startOffset = 0;
            this.startShift = 0;
            this.startShift = 0;
            this.dotAtStart = false;
            this.selection = false;
        }

        boolean overlapsAtStart(CaretItemInfo info) {
            return ComplexPositions.compare(info.endOffset, info.endShift, this.startOffset, this.startShift) > 0;
        }

        boolean startsBelow(CaretItemInfo info) {
            return ComplexPositions.compare(this.startOffset, this.startShift, info.startOffset, info.startShift) < 0;
        }

        boolean endsAbove(CaretItemInfo info) {
            return ComplexPositions.compare(this.endOffset, this.endShift, info.endOffset, info.endShift) > 0;
        }

        boolean dotsOverlap(CaretItemInfo info) {
            return ComplexPositions.compare(this.dotOffset, this.dotShift, info.dotOffset, info.dotShift) == 0;
        }

        public String toString() {
            return "DOS(" + this.dotOffset + "," + this.dotShift + ") <(" + this.startOffset + "," + this.startShift + "), (" + this.endOffset + "," + this.endShift + ")> dotAtStart=" + this.dotAtStart + ", selection=" + this.selection + "\n    caretItem=" + this.caretItem;
        }
    }

    static enum RemoveType {
        NO_REMOVE,
        REMOVE_LAST_CARET,
        RETAIN_LAST_CARET,
        REMOVE_ALL_CARETS,
        DOCUMENT_REMOVE,
        DOCUMENT_INSERT_ZERO_OFFSET,
        TOGGLE_CARET;

    }
}

