/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.support.FixFactory;
import org.openide.util.NbBundle;

public class OverridableMethodCallInConstructor {
    public static ErrorDescription hint(HintContext ctx) {
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        CompilationInfo info = ctx.getInfo();
        TreePath enclosingMethod = Utilities.findOwningExecutable(ctx, ctx.getPath(), false);
        if (enclosingMethod == null) {
            return null;
        }
        Element enclosingMethodElement = ctx.getInfo().getTrees().getElement(enclosingMethod);
        if (enclosingMethodElement == null || enclosingMethodElement.getKind() != ElementKind.CONSTRUCTOR) {
            return null;
        }
        Element methodInvocationElement = info.getTrees().getElement(new TreePath(ctx.getPath(), mit.getMethodSelect()));
        if (methodInvocationElement == null || methodInvocationElement.getKind() != ElementKind.METHOD) {
            return null;
        }
        Element classElement = methodInvocationElement.getEnclosingElement();
        if (classElement == null || classElement.getKind() != ElementKind.CLASS) {
            return null;
        }
        Element classEl = enclosingMethodElement.getEnclosingElement();
        if (classEl == null || classEl.getKind() != ElementKind.CLASS) {
            return null;
        }
        boolean sameClass = classElement.equals(enclosingMethodElement.getEnclosingElement());
        if (!info.getTypes().isSubtype(classEl.asType(), classElement.asType())) {
            return null;
        }
        if (classEl.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        Set<Modifier> modifiers = methodInvocationElement.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.FINAL) || modifiers.contains((Object)Modifier.STATIC)) {
            return null;
        }
        if (!OverridableMethodCallInConstructor.invocationOnThis(mit)) {
            return null;
        }
        TreePath methodDeclaration = ctx.getInfo().getTrees().getPath(methodInvocationElement);
        if (methodDeclaration == null || ctx.getInfo().getTreeUtilities().isSynthetic(methodDeclaration)) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, mit, NbBundle.getMessage(OverridableMethodCallInConstructor.class, "MSG_org.netbeans.modules.java.hints.OverridableMethodCallInConstructor"), sameClass ? OverridableMethodCallInConstructor.computeFixes((MethodTree)methodDeclaration.getLeaf(), classElement, ctx) : null);
    }

    private static Fix[] computeFixes(MethodTree mt, Element classElement, HintContext ctx) {
        ArrayList<Fix> result = new ArrayList<Fix>();
        Set<Modifier> flags = mt.getModifiers().getFlags();
        if (flags.contains((Object)Modifier.ABSTRACT)) {
            return result.toArray(new Fix[0]);
        }
        ClassTree ct = ctx.getInfo().getTrees().getTree((TypeElement)classElement);
        result.add(FixFactory.addModifiersFix(ctx.getInfo(), TreePath.getPath(ctx.getInfo().getCompilationUnit(), (Tree)ct.getModifiers()), Collections.singleton(Modifier.FINAL), NbBundle.getMessage(OverridableMethodCallInConstructor.class, "FIX_MakeClass", "final", ct.getSimpleName())));
        result.add(FixFactory.addModifiersFix(ctx.getInfo(), TreePath.getPath(ctx.getInfo().getCompilationUnit(), (Tree)mt.getModifiers()), Collections.singleton(Modifier.FINAL), NbBundle.getMessage(OverridableMethodCallInConstructor.class, "FIX_MakeMethod", "final", mt.getName())));
        result.add(FixFactory.addModifiersFix(ctx.getInfo(), TreePath.getPath(ctx.getInfo().getCompilationUnit(), (Tree)mt.getModifiers()), Collections.singleton(Modifier.STATIC), NbBundle.getMessage(OverridableMethodCallInConstructor.class, "FIX_MakeMethod", "static", mt.getName())));
        result.add(FixFactory.changeModifiersFix(ctx.getInfo(), TreePath.getPath(ctx.getInfo().getCompilationUnit(), (Tree)mt.getModifiers()), Collections.singleton(Modifier.PRIVATE), flags, NbBundle.getMessage(OverridableMethodCallInConstructor.class, "FIX_MakeMethod", "private", mt.getName())));
        return result.toArray(new Fix[result.size()]);
    }

    private static boolean invocationOnThis(MethodInvocationTree mit) {
        ExpressionTree select = mit.getMethodSelect();
        switch (select.getKind()) {
            case IDENTIFIER: {
                return true;
            }
            case MEMBER_SELECT: {
                if (((MemberSelectTree)select).getExpression().getKind() != Tree.Kind.IDENTIFIER) break;
                IdentifierTree ident = (IdentifierTree)((MemberSelectTree)select).getExpression();
                return ident.getName().contentEquals("this");
            }
        }
        return false;
    }
}

