/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.Collections;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.Name;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class UtilityClass {
    public static ErrorDescription utilityClass(HintContext ctx) {
        CompilationInfo compilationInfo = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        Element e = compilationInfo.getTrees().getElement(treePath);
        if (e == null) {
            return null;
        }
        if (!UtilityClass.isUtilityClass(compilationInfo, e)) {
            return null;
        }
        for (ExecutableElement c : ElementFilter.constructorsIn(e.getEnclosedElements())) {
            if (compilationInfo.getElementUtilities().isSynthetic(c)) continue;
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, treePath, NbBundle.getMessage(UtilityClass.class, "MSG_UtilityClass"), new FixImpl(true, TreePathHandle.create(e, compilationInfo)).toEditorFix());
    }

    public static ErrorDescription constructor(HintContext ctx) {
        CompilationInfo compilationInfo = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        Element e = compilationInfo.getTrees().getElement(treePath);
        if (e == null) {
            return null;
        }
        if (e.getKind() != ElementKind.CONSTRUCTOR || compilationInfo.getElementUtilities().isSynthetic(e) || !e.getModifiers().contains((Object)Modifier.PROTECTED) && !e.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return null;
        }
        if (!UtilityClass.isUtilityClass(compilationInfo, e.getEnclosingElement())) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, treePath, NbBundle.getMessage(UtilityClass.class, "MSG_PublicConstructor"), new FixImpl(false, TreePathHandle.create(e, compilationInfo)).toEditorFix());
    }

    private static boolean isMainMethod(ExecutableElement m) {
        return m.getModifiers().contains((Object)Modifier.STATIC) && m.getSimpleName().contentEquals("main") && m.getReturnType().getKind() == TypeKind.VOID && m.getParameters().size() == 1 && m.getParameters().get(0).asType().toString().equals("java.lang.String[]");
    }

    private static boolean isUtilityClass(CompilationInfo compilationInfo, Element clazz) {
        Name superName;
        if (clazz.getKind() != ElementKind.CLASS) {
            return false;
        }
        TypeMirror supr = ((TypeElement)clazz).getSuperclass();
        if (supr == null) {
            return false;
        }
        Element superElem = compilationInfo.getTypes().asElement(supr);
        if (superElem instanceof TypeElement && (superName = compilationInfo.getElements().getBinaryName((TypeElement)superElem)) != null && !superName.contentEquals("java.lang.Object")) {
            return false;
        }
        int cnt = 0;
        for (Element element : clazz.getEnclosedElements()) {
            if (element.getKind() == ElementKind.METHOD && UtilityClass.isMainMethod((ExecutableElement)element)) {
                return false;
            }
            if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.FIELD) continue;
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                return false;
            }
            ++cnt;
        }
        return cnt > 0;
    }

    private static final class FixImpl
    extends JavaFix {
        private boolean clazz;

        public FixImpl(boolean clazz, TreePathHandle handle) {
            super(handle);
            this.clazz = clazz;
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(UtilityClass.class, this.clazz ? "MSG_PrivateConstructor" : "MSG_MakePrivate");
        }

        public String toString() {
            return "FixUtilityClass";
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            Element e = wc.getTrees().getElement(tp);
            if (e == null) {
                return;
            }
            Tree outer = wc.getTrees().getTree(e);
            if (this.clazz) {
                if (outer == null || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)outer.getKind())) {
                    return;
                }
                ClassTree cls = (ClassTree)outer;
                ModifiersTree modifiers = wc.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE));
                MethodTree m = wc.getTreeMaker().Constructor(modifiers, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), wc.getTreeMaker().Block(Collections.emptyList(), false));
                wc.rewrite(cls, wc.getTreeMaker().addClassMember(cls, m));
            } else {
                if (outer == null || outer.getKind() != Tree.Kind.METHOD) {
                    return;
                }
                MethodTree met = (MethodTree)outer;
                ModifiersTree modifiers = wc.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE), met.getModifiers().getAnnotations());
                wc.rewrite(met.getModifiers(), modifiers);
            }
        }
    }
}

