/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.IfTree;
import jpt.sun.source.tree.InstanceOfTree;
import jpt.sun.source.tree.ParenthesizedTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.TypeCastTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.TreePathScanner;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;

public class ConvertToPatternInstanceOf {
    public static ErrorDescription trivial(final HintContext ctx) {
        if (!MatcherUtilities.matches(ctx, ctx.getPath(), "if ($expr instanceof $typeI) { $typeV $var = ($typeC) $expr; $other$;} else $else$;", true)) {
            final HashSet<TreePath> convertPath = new HashSet<TreePath>();
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitTypeCast(TypeCastTree node, Void p) {
                    if (MatcherUtilities.matches(ctx, this.getCurrentPath(), "($typeI) $expr")) {
                        convertPath.add(this.getCurrentPath());
                    }
                    return (Void)super.visitTypeCast(node, p);
                }
            }.scan(ctx.getPath(), (Void)null);
            if (!convertPath.isEmpty()) {
                TreePath typeI = ctx.getVariables().get("$typeI");
                TypeMirror typeITM = ctx.getInfo().getTrees().getTypeMirror(typeI);
                List<String> varNameCandidates = Utilities.varNamesSuggestions(typeITM, ElementKind.LOCAL_VARIABLE, EnumSet.noneOf(Modifier.class), null, null, ctx.getInfo().getTypes(), ctx.getInfo().getElements(), Collections.emptyList(), CodeStyle.getDefault(ctx.getInfo().getFileObject()));
                String varName = org.netbeans.modules.java.hints.errors.Utilities.makeNameUnique(ctx.getInfo(), ctx.getInfo().getTrees().getScope(ctx.getPath()), varNameCandidates.get(0));
                Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), varName, false, convertPath).toEditorFix();
                return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_ConvertToPatternInstanceOf(), fix);
            }
            return null;
        }
        if (ctx.getMultiVariables().get("$other$").isEmpty()) {
            return null;
        }
        TypeMirror typeI = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$typeI"));
        TypeMirror typeC = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$typeC"));
        if (!ctx.getInfo().getTypes().isSameType(typeI, typeC)) {
            System.err.println("different types (" + typeI + ", " + typeC + ") in " + ctx.getInfo().getFileObject());
            return null;
        }
        IfTree it = (IfTree)ctx.getPath().getLeaf();
        BlockTree bt = (BlockTree)it.getThenStatement();
        VariableTree var = (VariableTree)bt.getStatements().get(0);
        Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), var.getName().toString(), true, Collections.emptySet()).toEditorFix();
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_ConvertToPatternInstanceOf(), fix);
    }

    private static final class FixImpl
    extends JavaFix {
        private final String varName;
        private final boolean removeFirst;
        private final Set<TreePathHandle> replaceOccurrences;

        public FixImpl(CompilationInfo info, TreePath main, String varName, boolean removeFirst, Set<TreePath> replaceOccurrences) {
            super(info, main);
            this.varName = varName;
            this.removeFirst = removeFirst;
            this.replaceOccurrences = replaceOccurrences.stream().map(tp -> TreePathHandle.create(tp, info)).collect(Collectors.toSet());
        }

        @Override
        protected String getText() {
            return Bundle.FIX_ConvertToPatternInstanceOf();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath main = ctx.getPath();
            IfTree it = (IfTree)main.getLeaf();
            InstanceOfTree iot = (InstanceOfTree)((ParenthesizedTree)it.getCondition()).getExpression();
            StatementTree bt = it.getThenStatement();
            InstanceOfTree cond = wc.getTreeMaker().InstanceOf(iot.getExpression(), wc.getTreeMaker().BindingPattern(wc.getTreeMaker().Variable(wc.getTreeMaker().Modifiers(EnumSet.noneOf(Modifier.class)), this.varName, iot.getType(), null)));
            StatementTree thenBlock = this.removeFirst ? wc.getTreeMaker().removeBlockStatement((BlockTree)bt, 0) : bt;
            wc.rewrite(it, wc.getTreeMaker().If(wc.getTreeMaker().Parenthesized(cond), thenBlock, it.getElseStatement()));
            this.replaceOccurrences.stream().map(tph -> tph.resolve(wc)).forEach(tp -> {
                if (!this.removeFirst && tp.getParentPath().getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
                    tp = tp.getParentPath();
                }
                wc.rewrite(tp.getLeaf(), wc.getTreeMaker().Identifier(this.varName));
            });
        }
    }
}

